/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginConstants {
    public static <E extends Enum<E>> boolean contains(Class<E> _enumClass, String value) {
        try {
            return EnumSet.allOf(_enumClass).contains(Enum.valueOf(_enumClass, value));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum PullRequestState {
        OPEN,
        MERGED,
        REJECTED,
        DECLINED;


        private static PullRequestState forName(String name) {
            return PullRequestState.valueOf(name.toUpperCase());
        }
    }

    public static enum BuildStatus {
        SUCCEEDED,
        FAILED,
        RUNNING,
        UNKNOWN,
        SKIPPED,
        PLANNED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static BuildStatus fromString(String value) {
            return BuildStatus.valueOf(value == null ? null : value.toUpperCase());
        }
    }

    public static enum FieldType implements Serializable
    {
        STRING_NOT_ANALYZED("stringNotAnalyzed"),
        DOUBLE("double"),
        LONG("long"),
        MULTI_SELECT("multiSelect");

        private static Map<String, FieldType> byName;
        private String name;

        public static FieldType fromName(String name) {
            return byName.get(name);
        }

        private FieldType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            ConcurrentHashMap<String, FieldType> map = new ConcurrentHashMap<String, FieldType>();
            for (FieldType type : FieldType.values()) {
                map.put(type.getName(), type);
            }
            byName = Collections.unmodifiableMap(map);
        }
    }
}

