/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import okhttp3.HttpUrl;

public class GithubUrlHelper {
    public static final String API_VERSION_HEADER = "application/vnd.github.v3+json";

    public static URL probeUrl(URL endPoint) throws CrawlerWorkException {
        return GithubUrlHelper.basePathBuilder(endPoint.toString(), "user").build().url();
    }

    private static URL getURL(String endPoint) throws CrawlerWorkException {
        try {
            return new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    static HttpUrl.Builder baseUrlBuilder(String endPoint) throws CrawlerWorkException {
        if (endPoint != null && !endPoint.isEmpty()) {
            URL baseURL = GithubUrlHelper.getURL(endPoint);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseURL.getProtocol()).host(baseURL.getHost());
            String path = baseURL.getPath();
            while (path.contains("/")) {
                String segment = path.substring(0, path.indexOf(47));
                if (!segment.isEmpty()) {
                    builder.addPathSegment(segment);
                }
                path = path.substring(segment.length() + 1, path.length());
            }
            if (!path.isEmpty()) {
                builder.addPathSegment(path);
            }
            if (baseURL.getPort() != -1) {
                builder.port(baseURL.getPort());
            }
            return builder;
        }
        throw new CrawlerWorkException("Base URL can not be empty or null.");
    }

    private static HttpUrl.Builder basePathBuilder(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = GithubUrlHelper.baseUrlBuilder(endPoint);
        for (String path : pathSegments) {
            builder.addPathSegment(path);
        }
        return builder;
    }

    private static URL baseEntitiesURL(String endPoint, int limit, int page, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = GithubUrlHelper.basePathBuilder(endPoint, pathSegments);
        return builder.addQueryParameter("per_page", limit + "").addQueryParameter("page", page + "").build().url();
    }

    private static URL baseEntityURL(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = GithubUrlHelper.basePathBuilder(endPoint, pathSegments);
        return builder.build().url();
    }

    public static URL reposURL(String endPoint, int limit, int page) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntitiesURL(endPoint, limit, page, "user", "repos");
    }

    public static URL branchesURL(String endPoint, int limit, int page, String ownerName, String repoName) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntitiesURL(endPoint, limit, page, "repos", ownerName, repoName, "branches");
    }

    public static URL commitsURL(String endPoint, int limit, int page, String ownerName, String repoName, Date validDate) throws CrawlerWorkException {
        HttpUrl.Builder builder = GithubUrlHelper.basePathBuilder(endPoint, "repos", ownerName, repoName, "commits");
        return builder.addQueryParameter("per_page", limit + "").addQueryParameter("page", page + "").addQueryParameter("since", GithubUtil.iso8601FormatDate(validDate)).build().url();
    }

    public static URL commitURL(String endPoint, String orgName, String repoName, String id) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntityURL(endPoint, "repos", orgName, repoName, "commits", id);
    }

    public static URL tagsURL(String endPoint, String orgName, String repoName) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntityURL(endPoint, "repos", orgName, repoName, "git", "refs", "tags");
    }

    public static URL tagURL(String endPoint, String orgName, String repoName, String id) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntityURL(endPoint, "repos", orgName, repoName, "git", "tags", id);
    }

    public static URL pullRequestsURL(String endPoint, int limit, int page, String orgName, String repoName) throws CrawlerWorkException {
        HttpUrl.Builder builder = GithubUrlHelper.basePathBuilder(endPoint, "repos", orgName, repoName, "pulls");
        return builder.addQueryParameter("per_page", limit + "").addQueryParameter("page", page + "").addQueryParameter("state", "all").build().url();
    }

    public static URL pullRequestURL(String endPoint, String orgName, String repoName, String number) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntityURL(endPoint, "repos", orgName, repoName, "pulls", number);
    }

    public static URL pullRequestCommitsURL(String endPoint, int limit, int page, String orgName, String repoName, String number) throws CrawlerWorkException {
        return GithubUrlHelper.baseEntitiesURL(endPoint, limit, page, "repos", orgName, repoName, "pulls", number, "commits");
    }
}

