/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerDelayWorkException;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubConstants;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.services.CommitsCache;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.shared.services.BaseCrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GithubBaseCrawl<T extends GithubJobMessage, R>
extends BaseCrawlService<GithubCrawler, T, R> {
    private static final Logger logger = LoggerFactory.getLogger(GithubBaseCrawl.class);

    public GithubBaseCrawl(GithubCrawler crawler, T message, BaseCrawlerMessage dataMessage, ResponseFetcher<GithubCrawler> responseFetcher) {
        super((AbstractHttpCrawler)crawler, message, dataMessage, responseFetcher);
    }

    protected CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException {
        try {
            return this.processGithubMessage();
        }
        catch (CrawlerWorkException e) {
            if (GithubConstants.isRateLimitException((Exception)((Object)e))) {
                throw new CrawlerDelayWorkException((Throwable)e);
            }
            throw e;
        }
    }

    protected abstract CrawledDataWrappedResponse<R> processGithubMessage() throws CrawlerWorkException;

    protected GithubResponseFetcher getResponseFetcher() {
        return (GithubResponseFetcher)this.responseFetcher;
    }

    protected boolean isValidCommit(Commit c) {
        return c.getCommit().getAuthor().getTimeStamp().after(this.validDate);
    }

    protected void sendCommitDepthJobMessages(GithubRepoJobMessage repoMessage, Set<String> ids) throws CrawlerWorkException {
        logger.debug("Send Commit {} messages in org - {}, repo - {}", new Object[]{ids.size(), repoMessage.getOrgName(), repoMessage.getRepoName()});
        for (String id : ids) {
            GithubCommitJobMessage msg;
            if (CommitsCache.isCommitAlreadyRequested(repoMessage.getOrgName(), repoMessage.getRepoName(), id)) continue;
            try {
                msg = ((GithubCrawler)this.crawler).generateNewMessage(GithubCommitJobMessage.class, repoMessage).setId(id);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CrawlerWorkException((Throwable)e);
            }
            ((GithubCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(GithubCommitJobMessage.class.getSimpleName(), msg));
            CommitsCache.addRequestedCommit(repoMessage.getOrgName(), repoMessage.getRepoName(), id);
        }
    }
}

