/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Tag;
import com.xebialabs.agatha.crawlers.github.repository.LabelRepository;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.github.transform.converters.LabelConverter;
import com.xebialabs.agatha.crawlers.github.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubTagCrawl
extends GithubBaseCrawl<GithubTagJobMessage, Tag> {
    private static final Logger logger = LoggerFactory.getLogger(GithubTagCrawl.class);
    private final UMConverter<LabelUM, Tag> converter;
    private final KeyValueRepository<LabelUM> repository;

    public GithubTagCrawl(GithubCrawler crawler, GithubTagJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
        this.converter = new LabelConverter("GithubPlugin", "v1", "LABEL", "v1").setOrganization(message.getOrgName()).setRepo(message.getRepoName());
        this.repository = new LabelRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Tag> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubTagJobMessage for endpoint {} - tag - {}, org {}, repo - {}", new Object[]{((GithubTagJobMessage)this.message).getBaseUrl(), ((GithubTagJobMessage)this.message).getId(), ((GithubTagJobMessage)this.message).getOrgName(), ((GithubTagJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.getResponseFetcher().fetchEntity(Tag.class, ((GithubTagJobMessage)this.message).url());
        this.handleResponse((Tag)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(Tag tag) throws CrawlerWorkException {
        logger.debug("Saving tag {} in project - {}, repo - {}", new Object[]{tag.getSha(), ((GithubTagJobMessage)this.message).getOrgName(), ((GithubTagJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)tag);
        boolean crawlCommit = this.repository.save(umWrappedEntity);
        if (crawlCommit) {
            this.sendCommitDepthJobMessages((GithubRepoJobMessage)this.message, new HashSet<String>(Collections.singletonList(tag.getObject().getSha())));
        }
    }
}

