/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.transform.converters;

import com.xebialabs.agatha.crawlers.github.GithubUtil;
import com.xebialabs.agatha.crawlers.github.models.Tag;
import com.xebialabs.agatha.crawlers.github.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;

public class LabelConverter
implements UMConverter<LabelUM, Tag> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String organization;
    private String repo;

    public LabelConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public LabelConverter setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public LabelConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public UMWrappedEntity<LabelUM> convert(Tag tag) {
        LabelUM um = new LabelUM();
        this.populateTopLevelFields(tag, um);
        this.populateUrlParts(tag, um);
        this.populateOther(tag, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(um);
    }

    private void populateTopLevelFields(Tag tag, LabelUM um) {
        um.setId(this.generateId(tag.getSha()));
        um.setStartMs(tag.getTagger().getTimeStamp().getTime());
        um.setTitle(tag.getTag());
    }

    private void populateOther(Tag tag, LabelUM um) {
        LabelUM.Other other = new LabelUM.Other();
        other.setRaw((Object)tag);
        this.populateRelations(tag, other);
        um.setOther(other);
    }

    private void populateRelations(Tag tag, LabelUM.Other other) {
        HashMap<String, String> to = new HashMap<String, String>();
        to.put("to", this.generateId(tag.getObject().getSha()));
        HashMap<String, Object> relations = new HashMap<String, Object>();
        relations.put("commit", to);
        other.setRelations(relations);
    }

    private void populateUrlParts(Tag tag, LabelUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", GithubUtil.generateDataId(this.organization, this.repo));
        urlParts.put("organization", this.organization);
        urlParts.put("repo", this.repo);
        urlParts.put("title", tag.getTag());
        um.setUrlParts(urlParts);
    }

    private void populateAdditionalFields(LabelUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("organization", this.organization);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    private String generateId(String id) {
        return GithubUtil.generateDataId(this.organization, this.repo, id);
    }

    private UMWrappedEntity<LabelUM> wrappedEntity(LabelUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.LABEL).setId(um.getId()).setVersion("0").wrap();
    }
}

