import com.xebialabs.impact.api.CrawlerProbeResultVM
import com.xebialabs.impact.api.ProbeResultMetadataVM
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM
import com.xebialabs.impact.wave.scripting.PluginInterface
import java.util.stream.Collectors

class ProbeRequestSubscription {
    String endpoint;
    String username;
    String password;
}

class ProbeRequestWorkspaces extends ProbeRequestSubscription {
    String subscriptionId;
}

class ProbeRequest extends ProbeRequestWorkspaces {
    String workspaceId;
}

class ProbeWarmup {

}

class ProbeResultProjectsForCredentials {
    String username;
    String workspaceId;
    List<ProbeResultProject> projects = new ArrayList();

    def getAllProjects() {
        return "\n" + projects.stream().map { workspaceId + "/" + it.name }.collect(Collectors.joining("\n"))
    }
}

class ProbeResultProject {
    String name;
}

class ProbeResult {
    List<ProbeResultProjectsForCredentials> results = new ArrayList<>();
}

PluginInterface.probe().into(ProbeRequestSubscription, ProbeWarmup).via({ probe, ctx ->
    probe.getCredentialsToProbe().getCredentials().forEach { credentials ->
        p = new ProbeRequestSubscription()
        p.endpoint = probe.getCredentialsToProbe().endpoint
        p.username = credentials.getUsername()
        p.password = credentials.getPassword()
        ctx.emit(p)
    }
    ctx.emit(new ProbeWarmup())
})

PluginInterface.request(ProbeRequestSubscription).into(ProbeRequestWorkspaces)
    .mapToRequest({request, ctx ->
    RequestHelper.get(request.endpoint + "webservice/v2.0/subscription",
            request.username,
            request.password)
}).parseResponse({request, httpResponse, parser, ctx ->
    parser.readStringValueAndThen(".Subscription.ObjectID", {subscriptionId ->
        ProbeRequestWorkspaces probeRequestWorkspaces = new ProbeRequestWorkspaces()
        probeRequestWorkspaces.password = request.password
        probeRequestWorkspaces.username = request.username
        probeRequestWorkspaces.endpoint = request.endpoint
        probeRequestWorkspaces.subscriptionId = subscriptionId
        ctx.emit(probeRequestWorkspaces)
    })
})

PluginInterface.request(ProbeRequestWorkspaces).into(ProbeRequest)
    .mapToRequest({request, ctx ->
        RequestHelper.get(request.endpoint + "webservice/v2.0/Subscription/" + request.subscriptionId + "/Workspaces",
                request.username,
                request.password)
}).parseResponse({request, httpResponse, parser, ctx ->
    parser.readStringValueAndThen(".QueryResult.Results[].ObjectID", {workspaceId ->
        List<String> filterValues = ctx.crawlerMessageWithCredentials.credentials.getFilterValues("WORKSPACE_IDS")
        if (filterValues.isEmpty() || filterValues.stream().filter({workspaceId.equals(it)}).count() > 0) {
            ProbeRequest probeRequest = new ProbeRequest()
            probeRequest.username = request.username;
            probeRequest.password = request.password
            probeRequest.endpoint = request.endpoint
            probeRequest.subscriptionId = request.subscriptionId
            probeRequest.workspaceId = workspaceId
            ctx.emit(probeRequest)
        }
    })
})

PluginInterface.request(ProbeRequest).into(ProbeResultProjectsForCredentials)
        .mapToRequest { request, ctx ->
    RequestHelper.get(request.endpoint + "webservice/v2.0/Workspace/" + request.workspaceId + "/Projects",
            request.username,
            request.password
    )
}
.parseResponse { request, httpResponse, parser, ctx ->
    projects = new ProbeResultProjectsForCredentials()
    projects.username = request.username
    projects.workspaceId = request.workspaceId
    parser.readStringValueAndThen(".QueryResult.Results[]._refObjectName") { projectName ->
        project = new ProbeResultProject()
        project.name = projectName
        projects.projects.add(project)
    }
    parser.onFinish({
        ctx.emit(projects)
    })
}

PluginInterface.reduce(ProbeResultProjectsForCredentials, ProbeWarmup).into(ProbeResult).via({ stream ->
    result = new ProbeResult()
    stream.get({ resultForCredentials ->
        result.results.add(resultForCredentials)
    })
    stream.onFinish({
        stream.emit(result)
    })
})

PluginInterface.sendProbeResults(ProbeResult).mapRequest { results ->
    return new PushProbeUMStatusRequestVM()
            .setProbeStatus(new CrawlerProbeResultVM()
            .setResults(
            results.results.stream().map {
                new ProbeResultMetadataVM()
                        .setUsername(it.username)
                        .setReason(it.getAllProjects())
                        .setSuccess(!it.projects.isEmpty())
            }.collect(Collectors.toList())));

}

