/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.Element;
import com.xebialabs.impact.wave.scripting.engine.Handler;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import io.vavr.CheckedFunction1;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapturingHandler<S, C extends ContextBase<C>>
extends Handler<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(CapturingHandler.class);
    private final Class<S> src;
    private final CheckedFunction1<S, Object> fn;

    public CapturingHandler(Class<S> c, CheckedFunction1<S, Object> f) {
        super(Element.makeGenericName("capture", c, new Class[0]), c, new Class[0], new Class[0]);
        this.src = c;
        this.fn = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> handle(ComputingGraphBase<?, C> computingGraph, ObjectWrapper<?, C> object) {
        try {
            logger.info("Going to call +");
            Object result = null;
            try {
                result = this.fn.apply(object.getObject());
            }
            finally {
                logger.info("Going to call -");
            }
            return computingGraph.handleHandlerResult(object, null, result, false);
        }
        catch (Throwable throwable) {
            logger.error("Uncatched exception: ", throwable);
            return computingGraph.handleHandlerResult(object, null, CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
                throw new IllegalStateException(throwable);
            }), false);
        }
    }
}

