import akka.http.javadsl.model.HttpRequest
import akka.http.javadsl.model.headers.HttpCredentials
import com.xebialabs.impact.api.CrawlerProbeResultVM
import com.xebialabs.impact.api.ProbeResultMetadataVM
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM
import com.xebialabs.impact.wave.scripting.PluginInterface
import java.util.stream.Collectors

class ProbeRequest {
    String endpoint;
    String username;
    String password;
}

class ProbeResultProjectsForCredentials {
    String username;
    List<ProbeResultProject> projects = new ArrayList();

    def getAllProjects() {
        return projects.stream().map { it.name }.collect(Collectors.joining(", "))
    }
}

class ProbeResultProject {
    String name;
}

class ProbeResult {
    List<ProbeResultProjectsForCredentials> results = new ArrayList<>();
}

PluginInterface.probe().into(ProbeRequest).via({ probe, ctx ->
    probe.getCredentialsToProbe().getCredentials().forEach { credentials ->
        p = new ProbeRequest()
        p.endpoint = probe.getCredentialsToProbe().endpoint
        p.username = credentials.getUsername()
        p.password = credentials.getPassword()
        ctx.emit(p)
    }
})

PluginInterface.request(ProbeRequest).into(ProbeResultProjectsForCredentials)
        .mapToRequest { request, ctx ->
    RequestHelper.get(request.endpoint + "webservice/v2.0/project",
            request.username,
            request.password
    )
}
.parseResponse { request, httpResponse, parser, ctx ->
    projects = new ProbeResultProjectsForCredentials()
    projects.username = request.username
    parser.readStringValueAndThen(".QueryResult.Results[]._refObjectName") { projectName ->
        project = new ProbeResultProject()
        project.name = projectName
        projects.projects.add(project)
    }
    parser.onFinish({
        ctx.emit(projects)
    })
}

PluginInterface.reduce(ProbeResultProjectsForCredentials).into(ProbeResult).via({ stream ->
    result = new ProbeResult()
    stream.get({ resultForCredentials ->
        result.results.add(resultForCredentials)
    })
    stream.onFinish({
        stream.emit(result)
    })
})

PluginInterface.sendProbeResults(ProbeResult).mapRequest { results ->
    return new PushProbeUMStatusRequestVM()
            .setProbeStatus(new CrawlerProbeResultVM()
            .setResults(
            results.results.stream().map {
                new ProbeResultMetadataVM()
                        .setUsername(it.username)
                        .setReason(it.getAllProjects())
                        .setSuccess(!it.projects.isEmpty())
            }.collect(Collectors.toList())));

}

