/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.DebuggingPersistencyInterface;
import com.xebialabs.impact.wave.scripting.engine.Path;
import com.xebialabs.impact.wave.scripting.engine.Run;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectWrapper<T, C extends ContextBase<C>> {
    private final T object;
    private final Path path;
    private final Map<Class<?>, List<Object>> reducingGroupByValues = new HashMap();
    private DebuggingPersistencyInterface debuggingPersistencyInterface;
    private int depthLimit = -1;
    private Run run;
    private int stage;

    public ObjectWrapper(T object, ObjectWrapper<?, C> parent, String name) {
        this.object = object;
        this.path = new Path(parent == null ? null : parent.getPath(), name);
        DebuggingPersistencyInterface debuggingPersistencyInterface = this.debuggingPersistencyInterface = parent == null ? null : parent.debuggingPersistencyInterface;
        if (parent != null) {
            this.depthLimit = parent.depthLimit == -1 ? -1 : parent.depthLimit - 1;
            this.run = parent.run;
        }
    }

    public ObjectWrapper(T object, Path path, DebuggingPersistencyInterface debuggingPersistencyInterface) {
        this.object = object;
        this.path = path;
        this.debuggingPersistencyInterface = debuggingPersistencyInterface;
    }

    public T getObject() {
        return this.object;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<Class<?>, List<Object>> getReducingGroupByValues() {
        return this.reducingGroupByValues;
    }

    public String toString() {
        return this.path.getFullPath() + "(" + super.toString().replaceAll("^.*\\@", "") + ")";
    }

    public DebuggingPersistencyInterface getDebuggingPersistencyInterface() {
        return this.debuggingPersistencyInterface;
    }

    public void saveIfNecessary(Object object, String ... modifiers) {
        if (this.debuggingPersistencyInterface != null) {
            this.debuggingPersistencyInterface.save(this, object, modifiers);
        }
    }

    public ObjectWrapper<T, C> setDebuggingPersistencyInterface(DebuggingPersistencyInterface debuggingPersistencyInterface) {
        this.debuggingPersistencyInterface = debuggingPersistencyInterface;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectWrapper that = (ObjectWrapper)o;
        return Objects.equals(this.object, that.object) && Objects.equals(this.path, that.path) && Objects.equals(this.reducingGroupByValues, that.reducingGroupByValues) && Objects.equals(this.debuggingPersistencyInterface, that.debuggingPersistencyInterface);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.path, this.reducingGroupByValues, this.debuggingPersistencyInterface);
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public ObjectWrapper<T, C> setDepthLimit(int depthLimit) {
        this.depthLimit = depthLimit;
        return this;
    }

    public Run<C> getRun() {
        return this.run;
    }

    public ObjectWrapper<T, C> setRun(Run run) {
        this.run = run;
        return this;
    }

    public void rememberProcessedClass() {
        this.run.rememberProcessedClass(this.getObject().getClass().getSimpleName());
    }

    public int getStage() {
        return this.stage;
    }

    public ObjectWrapper<T, C> setStage(int stage) {
        this.stage = stage;
        return this;
    }
}

