/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.LogMessage;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextBase<C extends ContextBase<C>> {
    private static final Logger logger = LoggerFactory.getLogger(ContextBase.class);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final List<CompletableFuture<?>> futures = new ArrayList();
    private final ObjectWrapper<?, C> openedBy;
    private final String comment;
    private final Class<?>[] destinations;
    private final List<Object> bucket;
    private final AtomicInteger counter;
    private final Function<ObjectWrapper<?, C>, CompletableFuture<Void>> acceptor;

    public ContextBase(ObjectWrapper<?, C> openedBy, String comment, Class<?>[] destinations, List<Object> bucket, AtomicInteger counter, Function<ObjectWrapper<?, C>, CompletableFuture<Void>> acceptor) {
        this.openedBy = openedBy;
        this.comment = comment;
        this.destinations = destinations;
        this.bucket = bucket;
        this.counter = counter;
        this.acceptor = acceptor;
    }

    public List<CompletableFuture<?>> getFutures() {
        return this.futures;
    }

    public C closeEmitter() {
        this.open.set(false);
        return (C)this;
    }

    public ObjectWrapper<?, C> getOpenedBy() {
        return this.openedBy;
    }

    public C error(String msg, Object ... args) {
        this.emit(new LogMessage(LogMessage.Level.ERROR, msg, args));
        return (C)this;
    }

    public C warn(String msg, Object ... args) {
        this.emit(new LogMessage(LogMessage.Level.WARN, msg, args));
        return (C)this;
    }

    public C info(String msg, Object ... args) {
        this.emit(new LogMessage(LogMessage.Level.INFO, msg, args));
        return (C)this;
    }

    public C debug(String msg, Object ... args) {
        this.emit(new LogMessage(LogMessage.Level.DEBUG, msg, args));
        return (C)this;
    }

    public Object emit(Object ... dd) {
        if (!this.open.get()) {
            String msg = "Emitter is already closed: [" + this.openedBy.toString() + "], [" + this.comment + "]";
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        for (Object d : dd) {
            Objects.requireNonNull(d, () -> "Emitted object should not be null, emitter for [" + this.openedBy.toString() + "]");
            this.validateDestinations(this.destinations, d, this.openedBy, true);
            String name = d.getClass().getSimpleName() + "-" + this.createTuples(this.bucket, this.counter.getAndIncrement());
            ObjectWrapper<Object, C> objectWrapper = this.openedBy.getRun().wrapObject(d, this.openedBy, name);
            this.futures.add(this.acceptor.apply(objectWrapper));
        }
        return null;
    }

    public boolean isAllowedToEmit(Object ... args) {
        for (Object arg : args) {
            if (this.validateDestinations(this.destinations, arg, this.openedBy, false)) continue;
            return false;
        }
        return true;
    }

    private boolean validateDestinations(Class<?>[] destinations, Object object, ObjectWrapper<?, C> parent, boolean throwException) {
        for (Class<?> destination : destinations) {
            if (!destination.isInstance(object)) continue;
            return true;
        }
        if (throwException) {
            throw new IllegalStateException("Class [" + object.getClass().getName() + "] is not registered as output for processing stage for class [" + parent.getObject().getClass().getName() + "]");
        }
        return false;
    }

    private String createTuples(List<Object> bucket, int andIncrement) {
        if (bucket == null || bucket.isEmpty()) {
            return String.valueOf(andIncrement);
        }
        return Stream.concat(bucket.stream().map(Object::toString), Stream.of(String.valueOf(andIncrement))).collect(Collectors.joining("-"));
    }
}

