/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ingestion_api;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.wave.AckConsumer;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveActionResult;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.ingestion_api.BaseDataIngestionConsumer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class DataIngestionAckConsumer
extends BaseDataIngestionConsumer
implements AckConsumer {
    public DataIngestionAckConsumer(IngestionApiAsync ingestionApiAsync, String pluginId) {
        super(ingestionApiAsync, pluginId);
    }

    public CompletionStage<Void> apply(WaveAction waveAction, WaveActionResult.AckOrNack ackOrNack, WaveSystem waveSystem) {
        switch (ackOrNack) {
            case ACK: 
            case NACK: {
                return this.ingestionApiAsync.ackUmMessages(new AckUmMessagesVM().setDataSourceId(waveAction.getDataSourceDetails().getDataSourceId()).setNetworkId(AgathaConfiguration.getNetworkId()).setPluginId(this.pluginId).setTenantId(AgathaConfiguration.getTenantId()).setMessageIds(Collections.singletonList(waveAction.getMessageId())).setNack(ackOrNack == WaveActionResult.AckOrNack.NACK));
            }
            case NONE: {
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new IllegalArgumentException("Unknown value: [" + (Object)((Object)ackOrNack) + "]");
    }
}

