/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.Terminated;
import akka.event.Logging;
import akka.stream.ActorMaterializer;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import com.xebialabs.impact.wave.AckConsumer;
import com.xebialabs.impact.wave.Artefact;
import com.xebialabs.impact.wave.AsyncActionConsumer;
import com.xebialabs.impact.wave.AsyncContextKeysConsumer;
import com.xebialabs.impact.wave.AsyncDataConsumer;
import com.xebialabs.impact.wave.AsyncProbeResultConsumer;
import com.xebialabs.impact.wave.ContextKeyValue;
import com.xebialabs.impact.wave.ExceptionHandler;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveActionResult;
import com.xebialabs.impact.wave.scripting.PluginInterface;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.http.RequestComputingGraph;
import com.xebialabs.impact.wave.scripting.http.WaveRun;
import com.xebialabs.impact.wave.scripting.sandbox.Persistency;
import io.vavr.Function2;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveSystem {
    private static final Logger logger = LoggerFactory.getLogger(WaveSystem.class);
    private final AtomicBoolean runnable = new AtomicBoolean(true);
    private final Function2<WaveAction, Throwable, CompletionStage<Void>> exceptionHandler;
    private final AsyncActionConsumer asyncActionConsumer;
    private final AckConsumer ackConsumer;
    private final ActorSystem system;
    private final Materializer materializer;
    private final AsyncDataConsumer asyncDataConsumer;
    private final AsyncContextKeysConsumer asyncContextKeysConsumer;
    private final AsyncProbeResultConsumer asyncProbeResultConsumer;
    private final String scriptsFolder;

    public WaveSystem(AsyncActionConsumer asyncActionConsumer, AsyncDataConsumer asyncDataConsumer, AsyncContextKeysConsumer asyncContextKeysConsumer, AckConsumer ackConsumer, ExceptionHandler exceptionHandler, AsyncProbeResultConsumer asyncProbeResultConsumer, String scriptsFolder) {
        this.asyncActionConsumer = asyncActionConsumer;
        this.ackConsumer = ackConsumer;
        this.asyncDataConsumer = asyncDataConsumer;
        this.asyncContextKeysConsumer = asyncContextKeysConsumer;
        this.asyncProbeResultConsumer = asyncProbeResultConsumer;
        this.scriptsFolder = scriptsFolder;
        this.system = ActorSystem.create();
        this.materializer = ActorMaterializer.create((ActorRefFactory)this.system);
        this.exceptionHandler = exceptionHandler.apply(this.system, this.materializer);
    }

    public CompletionStage<Terminated> shutdown() {
        this.runnable.set(false);
        this.system.terminate();
        return this.system.getWhenTerminated();
    }

    public ActorSystem getSystem() {
        return this.system;
    }

    public Materializer getMaterializer() {
        return this.materializer;
    }

    public boolean isRunnable() {
        return this.runnable.get();
    }

    public void process(Source<CrawlerMessageWithCredentials, ?> actions) {
        Function<CrawlerMessageWithCredentials, CompletionStage> executeAction = theMessage -> {
            try {
                return ((CompletableFuture)CompletableFuture.completedFuture(theMessage).thenComposeAsync(message -> {
                    RequestComputingGraph currentComputingGraph = PluginInterface.getCurrentComputingGraph();
                    ObjectWrapper objectWrapper = new WaveRun(currentComputingGraph).wrapObject(message, null, new String[0]);
                    if (PluginInterface.isTrace()) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                        objectWrapper.setDebuggingPersistencyInterface(new Persistency(new File(String.format("%s/-logs/%s-%03d%04d", this.scriptsFolder, dateFormat.format(Date.from(Instant.now())), System.currentTimeMillis() % 1000L, ThreadLocalRandom.current().nextInt(0, 10000))), true));
                    }
                    return currentComputingGraph.compute(objectWrapper);
                })).handle((unused, throwable) -> {
                    if (throwable != null) {
                        logger.error("unhandled exception: ", throwable);
                    }
                    return true;
                });
            }
            catch (Exception ex) {
                logger.error("unhandled exception: ", (Throwable)ex);
                return CompletableFuture.completedFuture(true);
            }
        };
        actions.mapAsyncUnordered(8, executeAction::apply).log("before-map").withAttributes(Attributes.createLogLevels((int)Logging.DebugLevel(), (int)Logging.DebugLevel(), (int)Logging.DebugLevel())).runWith((Graph)Sink.ignore(), this.getMaterializer());
    }

    private WaveActionResult<? extends WaveAction> createDummyActionResult(WaveAction action) {
        return new WaveActionResult<WaveAction>(action, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), WaveActionResult.AckOrNack.NONE);
    }

    public CompletionStage<Void> sendMessage(WaveAction thisAction, Collection<WaveAction> nextActions, boolean dlq) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> sendData(WaveAction thisAction, Collection<Artefact> data) {
        return (CompletionStage)this.asyncDataConsumer.apply(thisAction, data, this);
    }

    public CompletionStage<Void> sendContextKey(WaveAction thisAction, Collection<ContextKeyValue> contextKeyValue) {
        return (CompletionStage)this.asyncContextKeysConsumer.apply(thisAction, contextKeyValue, this);
    }

    public CompletionStage<Void> sendProbeResult(WaveAction thisAction, Collection<ProbeResultMetadataVM> results) {
        return (CompletionStage)this.asyncProbeResultConsumer.apply(thisAction, results, this);
    }

    public CompletionStage<Void> sendAckOrNack(WaveAction thisAction, WaveActionResult.AckOrNack ackOrNack) {
        return (CompletionStage)this.ackConsumer.apply(thisAction, (Object)ackOrNack, this);
    }
}

