/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import com.xebialabs.impact.wave.Artefact;
import com.xebialabs.impact.wave.ContextKeyValue;
import com.xebialabs.impact.wave.WaveActionResult;
import com.xebialabs.impact.wave.WaveSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class WaveAction
extends BaseCrawlerMessage<WaveAction>
implements Function<WaveSystem, CompletionStage<Void>> {
    private CrawlerCredentialsDTO credentials;
    private String messageId;
    private WaveSystem waveSystem;
    private ConcurrentMap<CompletionStage<Void>, Boolean> messagesBeingSent = new ConcurrentHashMap<CompletionStage<Void>, Boolean>();
    private ConcurrentMap<CompletionStage<Void>, Boolean> dataBeingSent = new ConcurrentHashMap<CompletionStage<Void>, Boolean>();
    private ConcurrentMap<CompletionStage<Void>, Boolean> contextKeysBeingSent = new ConcurrentHashMap<CompletionStage<Void>, Boolean>();
    private ConcurrentMap<CompletionStage<Void>, Boolean> acknowledgeBeingSent = new ConcurrentHashMap<CompletionStage<Void>, Boolean>();

    public CrawlerCredentialsDTO getCredentials() {
        return this.credentials;
    }

    public WaveAction setCredentials(CrawlerCredentialsDTO credentials) {
        this.credentials = credentials;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public WaveAction setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @JsonIgnore
    public WaveSystem getWaveSystem() {
        return this.waveSystem;
    }

    public WaveAction setWaveSystem(WaveSystem waveSystem) {
        this.waveSystem = waveSystem;
        return this;
    }

    protected WaveActionResult<?> createResult(List<ProbeResultMetadataVM> probeResultList) {
        return new WaveActionResult<WaveAction>(this, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), probeResultList, WaveActionResult.AckOrNack.ACK);
    }

    protected CompletionStage<WaveActionResult<?>> createResultSync(List<ProbeResultMetadataVM> probeResultList) {
        return CompletableFuture.completedFuture(this.createResult(probeResultList));
    }

    protected CompletionStage<WaveActionResult<?>> createResultSync() {
        return CompletableFuture.completedFuture(new WaveActionResult<WaveAction>(this, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), WaveActionResult.AckOrNack.ACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> sendMessages(Collection<WaveAction> nextActions, boolean ... dlq) {
        WaveAction waveAction = this;
        synchronized (waveAction) {
            if (!(this.dataBeingSent.isEmpty() && this.contextKeysBeingSent.isEmpty() && this.acknowledgeBeingSent.isEmpty())) {
                throw new IllegalStateException("messages can not be sent if any data or context keys or ack requests are already sent");
            }
            return this.putAndReturn(this.messagesBeingSent, this.waveSystem.sendMessage(this, nextActions, dlq.length > 0 && dlq[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> sendData(Collection<Artefact> data) {
        WaveAction waveAction = this;
        synchronized (waveAction) {
            if (!this.contextKeysBeingSent.isEmpty() || !this.acknowledgeBeingSent.isEmpty()) {
                throw new IllegalStateException("data can not be sent if any context keys or ack requests are in progress");
            }
            return this.putAndReturn(this.dataBeingSent, WaveAction.allOf(this.messagesBeingSent.keySet()).thenComposeAsync(v -> this.waveSystem.sendData(this, data)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> sendContextKey(Collection<ContextKeyValue> contextKeyValues) {
        WaveAction waveAction = this;
        synchronized (waveAction) {
            if (!this.acknowledgeBeingSent.isEmpty()) {
                throw new IllegalStateException("context keys can not be sent if ack request is in progress");
            }
            return this.putAndReturn(this.contextKeysBeingSent, WaveAction.allOf(this.messagesBeingSent.keySet(), this.dataBeingSent.keySet()).thenComposeAsync(v -> this.waveSystem.sendContextKey(this, contextKeyValues)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> sendAckOrNack(WaveActionResult.AckOrNack ackOrNack) {
        WaveAction waveAction = this;
        synchronized (waveAction) {
            if (!this.acknowledgeBeingSent.isEmpty()) {
                throw new IllegalStateException("acks can be sent only once ");
            }
            return this.putAndReturn(this.acknowledgeBeingSent, WaveAction.allOf(this.messagesBeingSent.keySet(), this.dataBeingSent.keySet(), this.contextKeysBeingSent.keySet()).thenComposeAsync(v -> this.waveSystem.sendAckOrNack(this, ackOrNack)));
        }
    }

    public CompletionStage<Void> sendProbeResult(Collection<ProbeResultMetadataVM> results) {
        return this.waveSystem.sendProbeResult(this, results);
    }

    private CompletionStage<Void> putAndReturn(Map<CompletionStage<Void>, Boolean> set, CompletionStage<Void> completionStage) {
        set.put(completionStage, true);
        completionStage.whenComplete((r, e) -> {
            WaveAction waveAction = this;
            synchronized (waveAction) {
                set.remove(completionStage);
            }
        });
        return completionStage;
    }

    public static <T> List<CompletableFuture<T>> all(Collection<? extends CompletionStage<T>> ... collections) {
        ArrayList<CompletableFuture<T>> all = new ArrayList<CompletableFuture<T>>();
        for (Collection<CompletionStage<T>> collection : collections) {
            for (CompletionStage<T> voidCompletionStage : collection) {
                all.add(voidCompletionStage.toCompletableFuture());
            }
        }
        return all;
    }

    public static <T> CompletionStage<Void> allOf(Collection<? extends CompletionStage<T>> ... collections) {
        List<CompletableFuture<CompletableFuture>> all = WaveAction.all(collections);
        if (all.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(all.toArray(new CompletableFuture[all.size()]));
    }

    public static <T> CompletionStage<Void> allOf(CompletionStage<T> ... futures) {
        List<CompletableFuture<CompletableFuture>> all = WaveAction.all(Arrays.asList(futures));
        if (all.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(all.toArray(new CompletableFuture[all.size()]));
    }

    public static <T> CompletionStage<Collection<T>> allOfWithResults(Collection<? extends CompletionStage<T>> ... collections) {
        List all = WaveAction.all(collections);
        return WaveAction.allOf(all).thenApply(v -> all.stream().map(cs -> cs.getNow(null)).collect(Collectors.toList()));
    }

    public static <T> CompletionStage<Collection<T>> allOfWithResults(CompletionStage<T> ... stages) {
        return WaveAction.allOfWithResults(Arrays.asList(stages));
    }

    public CompletionStage<Void> applyAndWaitForAllPendingRequestsToComplete(WaveSystem waveSystem) {
        return ((CompletionStage)this.apply(waveSystem)).thenComposeAsync(this.getWaveActionResultCompletionStageFunction());
    }

    private Function<Void, CompletionStage<Void>> getWaveActionResultCompletionStageFunction() {
        return v -> {
            List all = WaveAction.all(this.messagesBeingSent.keySet(), this.dataBeingSent.keySet(), this.contextKeysBeingSent.keySet(), this.acknowledgeBeingSent.keySet());
            if (all.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return WaveAction.allOf(all).thenComposeAsync(this.getWaveActionResultCompletionStageFunction());
        };
    }

    protected CrawlerCredentialsDTO.CredentialsWrapper getNextCredentials() {
        List credentials = this.getCredentials().getCredentials();
        return (CrawlerCredentialsDTO.CredentialsWrapper)credentials.get(ThreadLocalRandom.current().nextInt(0, credentials.size()));
    }
}

