/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.BucketHandlerBinding;
import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.Handler;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.ReduceBucketStream;
import com.xebialabs.impact.wave.scripting.engine.ReduceGroupBy;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducingHandler<S, C extends ContextBase<C>>
extends Handler<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(ReducingHandler.class);
    private final ReduceGroupBy[] reduceGroupByCriteria;
    private final CheckedConsumer<ReduceBucketStream<S, C>> handler;
    private final ComputingGraphBase computingGraph;

    public ReducingHandler(String name, Class<S> firstSource, Class<?>[] sources, Class<?>[] destinations, ReduceGroupBy[] reduceGroupByCriteria, CheckedConsumer<ReduceBucketStream<S, C>> handler, ComputingGraphBase computingGraph) {
        super(name, firstSource, sources, destinations);
        this.reduceGroupByCriteria = reduceGroupByCriteria;
        this.handler = handler;
        this.computingGraph = computingGraph;
    }

    public ReduceGroupBy<?>[] getGroupBys() {
        return this.reduceGroupByCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> handle(ComputingGraphBase<?, C> computingGraph, ObjectWrapper<?, C> object) {
        BucketHandlerBinding bucketHandlerBinding;
        final List<Object> bucket = object.getReducingGroupByValues().get(this.firstSource);
        ReducingHandler reducingHandler = this;
        synchronized (reducingHandler) {
            bucketHandlerBinding = object.getRun().getReducerState(this).getBucketHandlerBindingMap().computeIfAbsent(bucket, unused -> {
                final BucketHandlerBinding binding = new BucketHandlerBinding(computingGraph.makeContext(object, "reduce", new AtomicInteger(0), bucket, this.destinations));
                try {
                    this.handler.accept((Object)new ReduceBucketStream<S, C>(){

                        @Override
                        public List<Object> getBucket() {
                            return bucket;
                        }

                        @Override
                        public void onFinish(CheckedFunction0<Object> fn) {
                            binding.setOnFinish(fn);
                        }

                        @Override
                        public void get(CheckedFunction1<S, Object> fn) {
                            binding.getConsumers().put(ReducingHandler.this.firstSource, fn);
                        }

                        @Override
                        public <T> void get(Class<T> aClass, CheckedFunction1<T, Object> fn) {
                            binding.getConsumers().put(aClass, fn);
                        }

                        @Override
                        public <T> void getWrapper(Class<T> aClass, CheckedFunction1<ObjectWrapper<T, C>, Object> fn) {
                            binding.getWrapperConsumers().put(aClass, fn);
                        }

                        @Override
                        public ReduceBucketStream<S, C> emit(Object ... o) {
                            binding.getContext().emit(o);
                            return this;
                        }

                        @Override
                        public boolean isAllowedToEmit(Object ... o) {
                            return binding.getContext().isAllowedToEmit(o);
                        }

                        @Override
                        public ReduceBucketStream<S, C> error(String msg, Object ... args) {
                            binding.getContext().error(msg, args);
                            return this;
                        }

                        @Override
                        public ReduceBucketStream<S, C> warn(String msg, Object ... args) {
                            binding.getContext().warn(msg, args);
                            return this;
                        }

                        @Override
                        public ReduceBucketStream<S, C> info(String msg, Object ... args) {
                            binding.getContext().info(msg, args);
                            return this;
                        }

                        @Override
                        public ReduceBucketStream<S, C> debug(String msg, Object ... args) {
                            binding.getContext().debug(msg, args);
                            return this;
                        }

                        @Override
                        public C ctx() {
                            return binding.getContext();
                        }
                    });
                }
                catch (Throwable throwable) {
                    logger.error("Uncatched exception: ", throwable);
                    throw new IllegalStateException(throwable);
                }
                return binding;
            });
        }
        CheckedFunction1<?, Object> consumer = bucketHandlerBinding.getConsumers().get(object.getObject().getClass());
        CheckedFunction1 rawConsumer = bucketHandlerBinding.getWrapperConsumers().get(object.getObject().getClass());
        ContextBase context = bucketHandlerBinding.getContext();
        object.rememberProcessedClass();
        try {
            Object result = null;
            BucketHandlerBinding bucketHandlerBinding2 = bucketHandlerBinding;
            synchronized (bucketHandlerBinding2) {
                if (consumer != null && rawConsumer != null) {
                    throw new IllegalStateException("You can register either get or getWrapper for same class, not both");
                }
                if (consumer != null) {
                    logger.info("Going to call + reduce");
                    try {
                        result = consumer.apply(object.getObject());
                    }
                    finally {
                        logger.info("Going to call - reduce");
                    }
                }
                if (rawConsumer != null) {
                    logger.info("Going to call + raw reduce");
                    try {
                        result = rawConsumer.apply(object);
                    }
                    finally {
                        logger.info("Going to call - raw reduce");
                    }
                }
            }
            return computingGraph.handleHandlerResult(object, null, result, false);
        }
        catch (Throwable throwable) {
            logger.error("Uncatched exception: ", throwable);
            return computingGraph.handleHandlerResult(object, context, CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
                throw new IllegalStateException(throwable);
            }), false);
        }
    }

    public CompletableFuture<Void> triggerReduceCounters(List<Object> objects, int shift, ObjectWrapper<?, C> t) {
        return t.getRun().getReducerState(this).getReducingBuckets().triggerCounters(objects, shift, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> finish(List<Object> bucket, BucketHandlerBinding binding, ObjectWrapper<?, C> object) {
        if (binding != null && binding.getOnFinish() != null) {
            BucketHandlerBinding bucketHandlerBinding = binding;
            synchronized (bucketHandlerBinding) {
                ContextBase context = binding.getContext();
                try {
                    if (binding.getFinished().getAndSet(true)) {
                        String msg = "Reducer bucket [" + this.getName() + "] onFinish already called once, trying to call another time for [" + bucket.toString() + "] on [" + object.toString() + "]";
                        logger.error(msg);
                        throw new IllegalStateException(msg);
                    }
                    logger.info("Going to call + onFinish");
                    Object result = null;
                    try {
                        result = binding.getOnFinish().apply();
                    }
                    finally {
                        logger.info("Going to call - onFinish");
                    }
                    return this.computingGraph.handleHandlerResult(object, context, result, true);
                }
                catch (Throwable throwable) {
                    logger.error("Uncatched exception: ", throwable);
                    return this.computingGraph.handleHandlerResult(object, context, CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
                        throw new IllegalStateException(throwable);
                    }), false);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

