/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class LabelConverter
implements UMConverter<LabelUM, Tag> {
    private static final String SHA_1 = "SHA-1";
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String project;
    private String repo;

    public LabelConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public String getProject() {
        return this.project;
    }

    public LabelConverter setProject(String project) {
        this.project = project;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public LabelConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    @Override
    public UMWrappedEntity<LabelUM> convert(Tag tag) {
        LabelUM um = new LabelUM();
        um.setId(this.generateId(this.computeHash(tag)));
        um.setTitle(tag.getDisplayId());
        this.populateUrlParts(tag, um);
        this.populateOther(tag, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(tag, um);
    }

    private String computeHash(Tag tag) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_1);
            return new BigInteger(1, md.digest((tag.getDisplayId() + "," + tag.getLatestCommit()).getBytes("UTF-8"))).toString(16);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateOther(Tag tag, LabelUM um) {
        LabelUM.Other other = new LabelUM.Other();
        other.setRaw(tag);
        this.populateRelations(tag, other);
        um.setOther(other);
    }

    private void populateRelations(Tag tag, LabelUM.Other other) {
        HashMap<String, String> to = new HashMap<String, String>();
        to.put("to", this.generateId(tag.getLatestCommit()));
        HashMap<String, Object> relations = new HashMap<String, Object>();
        relations.put("commit", to);
        other.setRelations(relations);
    }

    private void populateUrlParts(Tag tag, LabelUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", BitbucketServerUtil.generateDataId(this.project, this.repo));
        urlParts.put("project", this.project);
        urlParts.put("repo", this.repo);
        urlParts.put("title", tag.getId());
        um.setUrlParts(urlParts);
    }

    private void populateAdditionalFields(LabelUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("project", this.project);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    private String generateId(String id) {
        return BitbucketServerUtil.generateDataId(this.project, this.repo, id);
    }

    private UMWrappedEntity<LabelUM> wrappedEntity(Tag tag, LabelUM um) {
        return new UMWrappedEntity<LabelUM>(this.pluginId, this.pluginVersion, this.type, this.typeVersion, um, DataSourceTypeEnum.LABEL).setId(um.getId()).setVersion(this.computeHash(tag)).wrap();
    }
}

