/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.components;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawlService;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerBranchCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerCommitJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerCommitsJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerPullRequestJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerPullRequestsJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BitbucketServerTagsCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;

public class BitbucketCrawlFactory
extends BaseCrawlFactory<BitbucketServerCrawler> {
    private CrawlService jobCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerJobCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerJobMessage.class));
    }

    private CrawlService commitsCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerCommitsJobCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerCommitsJobMessage.class), crawlerDataMessage);
    }

    private CrawlService commitCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerCommitJobCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerCommitJobMessage.class), crawlerDataMessage);
    }

    private CrawlService tagCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerTagsCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerTagsJobMessage.class), crawlerDataMessage);
    }

    private CrawlService branchCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerBranchCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerBranchJobMessage.class), crawlerDataMessage);
    }

    private CrawlService pullRequestsCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerPullRequestsJobCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerPullRequestsJobMessage.class), crawlerDataMessage);
    }

    private CrawlService pullRequestCrawl(BitbucketServerCrawler crawler, BaseCrawlerMessage crawlerDataMessage) {
        return new BitbucketServerPullRequestJobCrawl(crawler, this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketServerPullRequestJobMessage.class), crawlerDataMessage);
    }

    @Override
    public CrawlService getInstance(BitbucketServerCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService crawlService;
        switch (message.getDataKey().toLowerCase()) {
            case "bitbucketserverjobmessage": {
                crawlService = this.jobCrawl(crawler, message);
                break;
            }
            case "bitbucketservercommitsjobmessage": {
                crawlService = this.commitsCrawl(crawler, message);
                break;
            }
            case "bitbucketservercommitjobmessage": {
                crawlService = this.commitCrawl(crawler, message);
                break;
            }
            case "bitbucketservertagsjobmessage": {
                crawlService = this.tagCrawl(crawler, message);
                break;
            }
            case "bitbucketserverbranchjobmessage": {
                crawlService = this.branchCrawl(crawler, message);
                break;
            }
            case "bitbucketserverpullrequestsjobmessage": {
                crawlService = this.pullRequestsCrawl(crawler, message);
                break;
            }
            case "bitbucketserverpullrequestjobmessage": {
                crawlService = this.pullRequestCrawl(crawler, message);
                break;
            }
            default: {
                throw new CrawlerWorkException("No Crawler implementation found.");
            }
        }
        return crawlService;
    }
}

