/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.CommitUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitConverter
implements UMConverter<CommitUM, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(CommitConverter.class);
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String project;
    private String repo;

    public CommitConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    @Override
    public UMWrappedEntity<CommitUM> convert(Commit entity) {
        CommitUM um = new CommitUM();
        um.setId(this.generateId(entity.getId()));
        this.populateAuthor(entity, um);
        um.setMessage(entity.getMessage());
        this.populateStartMs(entity, um);
        this.populateUrlParts(entity, um);
        this.populateOther(entity, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(entity, um);
    }

    private void populateStartMs(Commit entity, CommitUM um) {
        um.setStartMs(entity.getAuthorTimestamp().getTime());
        this.logErrorWhenConditionMet(d -> d.before(this.beforeThisDate()), entity, um);
    }

    private void logErrorWhenConditionMet(Predicate<Date> p, Commit entity, CommitUM um) {
        try {
            if (p.test(entity.getAuthorTimestamp())) {
                logger.error("Startms for commit {} is before 01/01/2000, Startms Value - {} Commit Value {}", new Object[]{entity.getId(), um.getStartMs(), entity.getAuthorTimestamp().getTime()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Date beforeThisDate() {
        long l = 946665000000L;
        return new Date(946665000000L);
    }

    private void populateAdditionalFields(CommitUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("project", this.project);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    private void populateOther(Commit entity, CommitUM um) {
        CommitUM.Other other = new CommitUM.Other();
        other.setChangedLines(entity.getChangeLog().getNoOfLinesChanged());
        other.setRaw(entity);
        this.populateRelations(entity, other);
        um.setOther(other);
    }

    private void populateRelations(Commit entity, CommitUM.Other other) {
        HashMap<String, Object> relations = new HashMap<String, Object>();
        List parents = entity.getParents().stream().map(o -> this.generateId(o.getId())).collect(Collectors.toList());
        relations.put("sha", entity.getId());
        relations.put("parents", parents);
        other.setRelations(relations);
    }

    private void populateUrlParts(Commit entity, CommitUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", BitbucketServerUtil.generateDataId(this.project, this.repo));
        urlParts.put("sha", entity.getId());
        urlParts.put("project", this.project);
        urlParts.put("repo", this.repo);
        um.setUrlParts(urlParts);
    }

    private void populateAuthor(Commit entity, CommitUM um) {
        um.setAuthorName(entity.getAuthor().getName());
        um.setAuthorEmail(entity.getAuthor().getEmailAddress());
    }

    private String generateId(String id) {
        return BitbucketServerUtil.generateDataId(this.project, this.repo, id);
    }

    private UMWrappedEntity<CommitUM> wrappedEntity(Commit entity, CommitUM um) {
        return new UMWrappedEntity<CommitUM>(this.pluginId, this.pluginVersion, this.type, this.typeVersion, um, DataSourceTypeEnum.COMMIT).setId(um.getId()).setVersion(entity.getId()).wrap();
    }

    public String getProject() {
        return this.project;
    }

    public CommitConverter setProject(String project) {
        this.project = project;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public CommitConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }
}

