/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.CommitsResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BasePaginatedCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerCommitsJobCrawl
extends BasePaginatedCrawl<BitbucketServerCommitsJobMessage, CommitsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerCommitsJobCrawl.class);

    public BitbucketServerCommitsJobCrawl(BitbucketServerCrawler crawler, BitbucketServerCommitsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    @Override
    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketServerJobMessage dm = this.crawler.generateNewMessage(BitbucketServerCommitsJobMessage.class, this.message).setLimit(((BitbucketServerCommitsJobMessage)this.message).getLimit()).setOffset(((BitbucketServerCommitsJobMessage)this.message).nextOffSet());
            return this.createDataMessage(this.message, BitbucketServerCommitsJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<CommitsResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerCommitsJobMessage for endpoint {} - project {}, repo - {} ", new Object[]{((BitbucketServerCommitsJobMessage)this.message).getBaseUrl(), ((BitbucketServerCommitsJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitsJobMessage)this.message).getRepoSlug()});
        CrawledDataWrappedResponse<CommitsResponse> response = this.responseFetcher.fetchEntity(CommitsResponse.class, ((BitbucketServerCommitsJobMessage)this.message).url());
        this.handleResponse(response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<CommitsResponse> response) throws CrawlerWorkException {
        CommitsResponse commitsResponse = response.getEntity();
        logger.debug("Found {} commits in project - {}, repo - {}", new Object[]{commitsResponse.getValues().size(), ((BitbucketServerCommitsJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitsJobMessage)this.message).getRepoSlug()});
        Set<String> filteredCommits = commitsResponse.getValues().stream().filter(this::isValidCommit).map(Commit::getId).collect(Collectors.toSet());
        this.sendCommitDepthJobMessages((BitbucketServerRepoJobMessage)this.message, filteredCommits);
    }
}

