/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.ResponseEntity;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import java.io.IOException;
import java.io.Reader;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpCrawler
extends AbstractCrawler<OkHttpClient, BaseCrawlerMessage, Response> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpCrawler.class);
    private static final int MAX_DOWNLOAD_BYTES = 200000000;
    private static final int SLEEP_MS_MAX = 20000;
    private static final int SLEEP_MS_MIN = 100;
    private static final int CONCURRENCY = AgathaConfiguration.getCrawlerThreads();
    private final AuthenticationTypes authenticationType;
    private PreAuthenticatingInterceptor authenticator;
    private double oldDelay;
    private int calculatedSleepTime;
    protected boolean autoThrottleEnabled = true;

    public AbstractHttpCrawler(String pluginId, AuthenticationTypes authenticationType) {
        super(pluginId);
        this.authenticationType = authenticationType;
    }

    public AbstractHttpCrawler(String pluginId, AuthenticationTypes authenticationType, Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super(pluginId, ingestionApiProvider);
        this.authenticationType = authenticationType;
    }

    @Override
    public void initOrUpdateClient() {
        if (this.client == null) {
            this.authenticator = this.authenticationType.isTokenBased() ? new PreAuthenticatingInterceptor(this.passwordOrToken) : new PreAuthenticatingInterceptor(this.username, this.passwordOrToken);
            this.client = this.createHttpClient(this.authenticator);
        } else if (this.authenticationType.isTokenBased()) {
            this.authenticator.updateCredentials(this.passwordOrToken);
        } else {
            this.authenticator.updateCredentials(this.username, this.passwordOrToken);
        }
        this.setThrottleFactor(this.crawlerCredentialsPackage.getThrottleFactor());
    }

    protected OkHttpClient createHttpClient(Interceptor authInterceptor) {
        OkHttpClient.Builder serverBuilder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(180L, TimeUnit.SECONDS).addInterceptor(authInterceptor);
        if (AgathaConfiguration.isSelfSignedCertsTrustedWhileCrawling()) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                serverBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
                serverBuilder.hostnameVerifier((hostname, session) -> true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating HTTP client trusting all certs: " + e);
            }
        }
        return serverBuilder.build();
    }

    public String getResponseBody(Request request) throws CrawlerWorkException {
        ResponseEntity responseEntity = this.getResponseAsEntity(request);
        return responseEntity.asString();
    }

    public char[] getResponseBodyAsChars(Request request) throws CrawlerWorkException {
        return this.getResponseAsEntity(request).getChars();
    }

    /*
     * Exception decompiling
     */
    public ResponseEntity getResponseAsEntity(Request request) throws CrawlerWorkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Reader getResponseBodyAsStream(Request request) throws CrawlerWorkException {
        try {
            this.remoteSource = ((OkHttpClient)this.client).newCall(request).execute();
            if (!((Response)this.remoteSource).isSuccessful()) {
                throw new CrawlerWorkException(String.format("Error in HTTP call [%s] | Response status: %s", request, ((Response)this.remoteSource).code()));
            }
            this.calculateAndSetDelay(((Response)this.remoteSource).receivedResponseAtMillis() - ((Response)this.remoteSource).sentRequestAtMillis(), ((Response)this.remoteSource).isSuccessful());
            return ((Response)this.remoteSource).body().charStream();
        }
        catch (IOException | ArithmeticException e) {
            ((Response)this.remoteSource).close();
            throw new CrawlerWorkException(e);
        }
    }

    private void calculateAndSetDelay(long latency, boolean isSuccess) {
        double targetDelay = (double)latency / (double)CONCURRENCY;
        double newDelay = (this.oldDelay + targetDelay) / 2.0;
        newDelay = Math.max(targetDelay, newDelay);
        newDelay = Math.min(Math.max(100.0, newDelay), 20000.0);
        if (isSuccess || newDelay > this.oldDelay) {
            this.oldDelay = newDelay;
            this.calculatedSleepTime = Math.toIntExact(Math.round(this.applyThrottleFactor(newDelay)));
        }
    }

    private double applyThrottleFactor(double time) {
        return time * this.throttleFactor;
    }

    @Override
    protected void ackMessage(String messageId, String tenantId, String pluginId, String dataSourceId, String networkId) {
        super.ackMessage(messageId, tenantId, pluginId, dataSourceId, networkId);
        if (this.autoThrottleEnabled && this.calculatedSleepTime != 0) {
            try {
                logger.info("[Auto-Throttle Mode] Sleeping for {}ms", (Object)this.calculatedSleepTime);
                Thread.sleep(this.calculatedSleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread interrupted", e);
            }
        }
    }

    public void runLimited(int limit) throws CrawlerWorkException {
        int count = 0;
        while (this.isRunning.get()) {
            ++count;
            Optional<CrawlerMessageWithCredentials> pollResponse = this.pollWorkQueue();
            if (!pollResponse.isPresent()) {
                if (limit != -1 && count <= limit) continue;
                break;
            }
            Optional<CrawlerJobWrapper> crawlerJob = this.handlePollResponse(pollResponse.get());
            if (crawlerJob.isPresent()) {
                this.crawlerCredentialsPackage = crawlerJob.get().getCredentialsPackage();
                if (this.crawlerCredentialsPackage.getCredentials().isEmpty()) {
                    throw new CrawlerWorkException("Crawler credentials wrapper doesn't include any credentials!");
                }
                this.endpoint = HttpUrl.parse(this.crawlerCredentialsPackage.getEndpoint()).url();
                this.switchCredentials(this.crawlerCredentialsPackage.getCredentials());
                this.initOrUpdateClient();
                this.execute(crawlerJob.get());
            }
            if (limit == -1 || count <= limit) continue;
            break;
        }
        this.shutdown();
    }

    public static class PreAuthenticatingInterceptor
    implements Interceptor {
        private String authHeader;

        public PreAuthenticatingInterceptor(String user, String password) {
            this.authHeader = Credentials.basic(user, password);
        }

        public PreAuthenticatingInterceptor(String token) {
            this.authHeader = token;
        }

        public void updateCredentials(String user, String password) {
            this.authHeader = Credentials.basic(user, password);
        }

        public void updateCredentials(String token) {
            this.authHeader = token;
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request preAuthRequest = chain.request().newBuilder().header("Authorization", this.authHeader).build();
            return chain.proceed(preAuthRequest);
        }
    }

    public static enum AuthenticationTypes {
        AUTH_USERNAME_PASSWORD,
        AUTH_TOKEN;


        public boolean isTokenBased() {
            return this.equals((Object)AUTH_TOKEN);
        }
    }
}

