/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Activity;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Comment;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.User;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.Other;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.Relations;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class OthersAggregator
implements Aggregator {
    private String project;
    private String repo;

    public OthersAggregator(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    @Override
    public void populate(PullRequestUM pullRequestUM, PullRequest pullRequest) {
        if (pullRequestUM.getOther() == null) {
            pullRequestUM.setOther(new Other());
        }
        Other other = pullRequestUM.getOther();
        other.setRelations(this.relations(pullRequest));
        other.setCommits(this.noOfCommits(pullRequest));
        other.setComments(this.noOfComments(pullRequest));
        other.setDescription(pullRequest.getDescription());
        other.setCreatedBy(pullRequest.getAuthor().getUser().getDisplayName());
        other.setMergedBy(this.mergedBy(pullRequest));
        other.setChangedFiles(pullRequest.getChangeLog().getNoOfFilesChanged());
        other.setChangedLines(pullRequest.getChangeLog().getNoOfLinesChanged());
        other.setRaw(pullRequest);
    }

    private String mergedBy(PullRequest pullRequest) {
        return this.doneBy(pullRequest, activity -> activity.getAction().equalsIgnoreCase("merged"));
    }

    private String doneBy(PullRequest pullRequest, Predicate<Activity> actionTypeValidator) {
        if (pullRequest.getActivities() == null) {
            return null;
        }
        return pullRequest.getActivities().stream().filter(actionTypeValidator).findFirst().map(Activity::getUser).map(User::getDisplayName).orElse(null);
    }

    private int noOfCommits(PullRequest pullRequest) {
        List<String> commitIds = this.commitIds(pullRequest);
        return commitIds == null || commitIds.isEmpty() ? 0 : commitIds.size();
    }

    private int noOfComments(PullRequest pullRequest) {
        if (pullRequest.getActivities() == null) {
            return 0;
        }
        return pullRequest.getActivities().stream().map(Activity::getComment).mapToInt(this::countIncludingNestedComments).sum();
    }

    private int countIncludingNestedComments(Comment comment) {
        if (comment == null) {
            return 0;
        }
        if (comment.getReplies() == null) {
            return 1;
        }
        return 1 + comment.getReplies().stream().mapToInt(this::countIncludingNestedComments).sum();
    }

    private Relations relations(PullRequest pullRequest) {
        Relations relations = new Relations();
        HashMap<String, Object> commitsMap = new HashMap<String, Object>();
        List<String> commitIds = this.commitIds(pullRequest);
        commitsMap.put("to", commitIds);
        relations.setCommits(commitsMap);
        relations.setLastCommitId(this.lastCommitId(pullRequest));
        relations.setMergeCommitId(this.mergeCommitId(pullRequest));
        return relations;
    }

    private String lastCommitId(PullRequest pullRequest) {
        return this.generateId(pullRequest.getFromRef().getLatestCommit());
    }

    private String mergeCommitId(PullRequest pullRequest) {
        String mergeCommitId = pullRequest.getActivities().stream().filter(activity -> activity.getAction().equalsIgnoreCase("merged")).findFirst().map(Activity::getCommit).map(Commit::getId).orElse(null);
        return this.generateId(mergeCommitId);
    }

    private List<String> commitIds(PullRequest pullRequest) {
        if (pullRequest.getCommits() == null || pullRequest.getCommits().isEmpty()) {
            return null;
        }
        return pullRequest.getCommits().stream().map(commit -> this.generateId(commit.getId())).collect(Collectors.toList());
    }

    private String generateId(String id) {
        return id == null ? null : BitbucketServerUtil.generateDataId(this.project, this.repo, id);
    }
}

