/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerURLHelper;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators.PRDataAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.CommitsResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PullRequestCommitsAggregator
implements PRDataAggregator {
    private final BitbucketServerPullRequestJobMessage message;
    private final ResponseFetcher<BitbucketServerCrawler> responseFetcher;

    public PullRequestCommitsAggregator(BitbucketServerPullRequestJobMessage message, BitbucketServerCrawler crawler) {
        this.message = message;
        this.responseFetcher = new ResponseFetcher<BitbucketServerCrawler>(crawler);
    }

    @Override
    public void populate(PullRequest pullRequest) throws CrawlerWorkException {
        pullRequest.setCommits(this.getCommits());
    }

    private List<Commit> getCommits() throws CrawlerWorkException {
        CrawledDataWrappedResponse<CommitsResponse> response;
        URL url = this.prCommitsUrl(0, 25);
        ArrayList<Commit> commits = new ArrayList<Commit>();
        while (!CrawledDataWrappedResponse.isEmpty(response = this.responseFetcher.fetchEntity(CommitsResponse.class, url))) {
            commits.addAll(response.getEntity().getValues());
            if (CrawledDataWrappedResponse.isLastPage(response)) break;
            url = this.prCommitsUrl(response.getEntity().getNextPageStart(), 25);
            if (!CrawledDataWrappedResponse.isEmpty(response)) continue;
        }
        return commits;
    }

    private URL prCommitsUrl(int offset, int limit) throws CrawlerWorkException {
        return BitbucketServerURLHelper.pullRequestCommitsURL(this.message.getBaseUrl(), limit, offset, this.message.getProjectKey(), this.message.getRepoSlug(), Long.toString(this.message.getId()));
    }
}

