/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.services;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerDataMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.shared.models.PaginatedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCrawlService<C extends AbstractHttpCrawler, T extends CrawlerMessage, R>
implements CrawlService {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlService.class);
    protected final ResponseFetcher<C> responseFetcher;
    protected final C crawler;
    protected final T message;
    protected final CrawlerDataMessage dataMessage;
    protected final Date validDate;

    public BaseCrawlService(C crawler, T message, CrawlerDataMessage dataMessage) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.validDate = crawler.getOldestValidDate();
        this.responseFetcher = new ResponseFetcher<C>(crawler);
    }

    public BaseCrawlService(C crawler, T message, CrawlerDataMessage dataMessage, ResponseFetcher<C> responseFetcher) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.validDate = crawler.getOldestValidDate();
        this.responseFetcher = responseFetcher;
    }

    protected CrawlerDataMessage createDataMessage(T message, String dataKey, String json) {
        CrawlerDataMessage dataMessage = new CrawlerDataMessage();
        dataMessage.setTenantId(message.getTenantId());
        dataMessage.setPluginId(message.getPluginId());
        dataMessage.setMetadata(message.getMetadata());
        dataMessage.setDataSourceDetails(message.getDataSourceDetails());
        dataMessage.setDataKey(dataKey);
        dataMessage.setDataValue(new CrawlerDataMessage.JsonString().setValue(json));
        return dataMessage;
    }

    @Override
    public void execute() throws CrawlerWorkException {
        if (!this.isValid()) {
            logger.debug("message - {} is not valid.", (Object)this.message.toString());
            return;
        }
        CrawledDataWrappedResponse<R> response = this.processMessage();
        if (this instanceof Paginated) {
            this.handlePagination(response);
        }
    }

    private void handlePagination(CrawledDataWrappedResponse<R> response) throws CrawlerWorkException {
        CrawlerDataMessage m;
        if (response.getEntity() instanceof PaginatedResponse && ((PaginatedResponse)response.getEntity()).hasNext() && null != (m = this.newMessage())) {
            this.crawler.sendCrawlerTaskMessage((CrawlerMessage)m);
        }
    }

    protected List<String> filterFromEnvironment(String key) {
        if (null == System.getenv(key)) {
            return Collections.emptyList();
        }
        return Arrays.stream(System.getenv(key).split(",")).filter(s -> s != null && !s.isEmpty()).map(String::trim).collect(Collectors.toList());
    }

    protected boolean filter(List<String> filterValues, String value) {
        return filterValues == null || filterValues.isEmpty() || filterValues.contains(value);
    }

    protected List<String> filters(String key) {
        if (null == this.crawler.getFilterValues(key)) {
            return Collections.emptyList();
        }
        return IntStream.range(0, this.crawler.getFilterValues(key).getFilterCount()).mapToObj(i -> this.crawler.getFilterValues(key).getFilter(i)).collect(Collectors.toList());
    }

    protected CrawlerDataMessage newMessage() throws CrawlerWorkException {
        return null;
    }

    protected abstract CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException;

    protected boolean isValid() {
        return true;
    }
}

