/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.components;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.xebialabs.agatha.crawlers.bitbucket.models.Links;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LinksDeserializer
extends StdDeserializer<Links> {
    private final List<String> whiteListedLabels = Collections.unmodifiableList(Stream.of("commits", "comments", "pullrequests", "diff", "tags", "branches", "repositories", "self", "activity").collect(Collectors.toList()));

    public LinksDeserializer() {
        this(null);
    }

    public LinksDeserializer(Class<Links> vc) {
        super(vc);
    }

    public Links deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        Iterator iterator = node.fields();
        HashMap<String, String> linkReferences = new HashMap<String, String>();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                switch (((JsonNode)entry.getValue()).getNodeType().name()) {
                    case "OBJECT": {
                        if (!this.isWhitelisted((String)entry.getKey())) break;
                        linkReferences.put((String)entry.getKey(), ((JsonNode)entry.getValue()).get("href").asText());
                    }
                }
            }
            return new Links(linkReferences);
        }
        return null;
    }

    private boolean isWhitelisted(String label) {
        return this.whiteListedLabels.contains(label.toLowerCase());
    }
}

