/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.api;

import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.CrawlerResourcesMetrics;
import com.xebialabs.impact.api.PluginRuntimeConfig;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class IngestionApiImpl
implements IngestionApi {
    private final IngestionApiAsync ingestionApiAsync;

    public IngestionApiImpl(IngestionApiAsync ingestionApiAsync) {
        this.ingestionApiAsync = ingestionApiAsync;
    }

    private <T> T get(CompletionStage<T> stage) {
        try {
            return stage.toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PullMessagesWithStreamingResponseVM pullUMMessage(String pluginId, String networkId) {
        return this.get(this.ingestionApiAsync.pullUMMessage(pluginId, networkId));
    }

    @Override
    public PluginRuntimeConfig pushCrawlerResourcesMetrics(CrawlerResourcesMetrics metrics) {
        return this.get(this.ingestionApiAsync.pushCrawlerResourcesMetrics(metrics));
    }

    @Override
    public void pushUMMessage(PushCrawlerUMMessagesRequestVM messages) {
        this.get(this.ingestionApiAsync.pushUMMessage(messages));
    }

    @Override
    public void ackUmMessages(AckUmMessagesVM acks) {
        this.get(this.ingestionApiAsync.ackUmMessages(acks));
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMData(Map<String, Object> payload) {
        return this.get(this.ingestionApiAsync.pushUMData(payload));
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMDataAsSource(Map<String, Object> payload, Reader reader) {
        return this.get(this.ingestionApiAsync.pushUMDataAsSource(payload, reader));
    }

    @Override
    public void pushProbeUmStatus(PushProbeUMStatusRequestVM pushProbeUMStatusRequestVM) {
        this.get(this.ingestionApiAsync.pushProbeUmStatus(pushProbeUMStatusRequestVM));
    }

    @Override
    public CheckWhichUMArtefactsAreKnownResponseVM checkWhichUMArtefactsAreKnown(CheckWhichUMArtefactsAreKnownRequestVM request) {
        return this.get(this.ingestionApiAsync.checkWhichUMArtefactsAreKnown(request));
    }

    @Override
    public void reportCrawlerLog(ReportCrawlerLogMessageRequestVM reportCrawlerLogMessageRequestVM) {
        this.get(this.ingestionApiAsync.reportCrawlerLog(reportCrawlerLogMessageRequestVM));
    }

    @Override
    public void shutdown() {
        this.ingestionApiAsync.shutdown();
    }
}

