/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.LabelUM;
import java.util.HashMap;

public class OthersAggregator
implements Aggregator<LabelUM, Tag> {
    private String team;
    private String repo;

    public OthersAggregator(String team, String repo) {
        this.team = team;
        this.repo = repo;
    }

    @Override
    public void populate(LabelUM um, Tag tag) {
        if (um.getOther() == null) {
            um.setOther(new LabelUM.Other());
        }
        LabelUM.Other other = um.getOther();
        other.setRaw(tag);
        this.populateRelations(tag, other);
        um.setOther(other);
    }

    private void populateRelations(Tag tag, LabelUM.Other other) {
        HashMap<String, String> to = new HashMap<String, String>();
        to.put("to", this.generateId(tag.getTarget().getHash()));
        HashMap<String, Object> relations = new HashMap<String, Object>();
        relations.put("commit", to);
        other.setRelations(relations);
    }

    private String generateId(String id) {
        return BitbucketUtil.generateDataId(this.team, this.repo, id);
    }
}

