/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawlerRateLimited;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUrlHelper;
import com.xebialabs.agatha.crawlers.bitbucket.components.BitbucketCrawlResolver;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTeamJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.TeamsResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCrawler
extends AbstractHttpCrawlerRateLimited {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketCrawler.class);
    private final CrawlResolver<BitbucketCrawler> crawlResolver = new BitbucketCrawlResolver();
    private static final LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> blockedCredentials = BitbucketCrawler.buildCache(3600000L);

    public BitbucketCrawler() {
        super("BitbucketCloudPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public BitbucketCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("BitbucketCloudPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected static LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> buildCache(long rateLimitWaitTime) {
        return CacheBuilder.newBuilder().concurrencyLevel(AgathaConfiguration.getCrawlerThreads()).maximumSize(50L).expireAfterWrite(rateLimitWaitTime, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<CrawlerCredentialsDTO.CredentialsWrapper, Boolean>(){

            public Boolean load(CrawlerCredentialsDTO.CredentialsWrapper key) throws Exception {
                return true;
            }
        });
    }

    public void switchCredentials(List<CrawlerCredentialsDTO.CredentialsWrapper> credentialsList) {
        List availableCredentials = this.getAvailableCredentialsStream(credentialsList).collect(Collectors.toList());
        if (!availableCredentials.isEmpty()) {
            super.switchCredentials(availableCredentials);
        } else {
            super.switchCredentials(credentialsList);
        }
    }

    protected void executeSingleLoop() {
        if (this.shouldBlockAllThreads.get()) {
            logger.warn("Got sleep request from another thread, sleeping thread for {} ms..", (Object)3600000L);
            try {
                Thread.sleep(3600000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                logger.warn("Exception while trying to sleep: {}", (Throwable)ie);
            }
        }
        super.executeSingleLoop();
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = this.crawlResolver.resolve((AbstractCrawler)this, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return this.handleCrawlerException(crawlerJob, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJobWrapper) {
        Request request;
        ProbeResultMetadataVM resultBuilder = new ProbeResultMetadataVM().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            request = new Request.Builder().url(BitbucketUrlHelper.probeUrl(this.getEndpoint())).build();
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot construct Bitbucket probe URL!");
            return resultBuilder.setSuccess(false).setReason(e.getMessage());
        }
        try (Response response = ((OkHttpClient)this.getClient()).newCall(request).execute();){
            if (this.isProbeSuccessfull(response)) {
                ProbeResultMetadataVM probeResultMetadataVM2 = resultBuilder.setSuccess(true);
                return probeResultMetadataVM2;
            }
            logger.warn("Bitbucket probe was not successful for user: {}", (Object)this.username);
            ProbeResultMetadataVM probeResultMetadataVM = resultBuilder.setSuccess(false).setReason("Status: " + response.code());
            return probeResultMetadataVM;
        }
        catch (IOException e) {
            logger.warn("Bitbucket probe was not successful for user: {}", (Object)this.username);
            return resultBuilder.setSuccess(false).setReason(e.getMessage());
        }
    }

    private boolean isProbeSuccessfull(Response response) throws IOException {
        if (response.isSuccessful()) {
            String content = response.body().string();
            TeamsResponse parsedProbeResponse = (TeamsResponse)((Object)this.mapper.readValue(content, TeamsResponse.class));
            if (parsedProbeResponse.getValues() == null || parsedProbeResponse.getValues().isEmpty()) {
                logger.info("No team found for user: {}", (Object)this.username);
                return false;
            }
            return true;
        }
        return false;
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        BitbucketJobMessage old;
        BitbucketJobMessage newMsg;
        BaseCrawlerMessage v = super.generateNewMessage(cls, oldMsg);
        if (v instanceof BitbucketRepoJobMessage && oldMsg instanceof BitbucketRepoJobMessage) {
            newMsg = (BitbucketRepoJobMessage)v;
            old = (BitbucketRepoJobMessage)oldMsg;
            ((BitbucketRepoJobMessage)newMsg).setRepoId(((BitbucketRepoJobMessage)old).getRepoId()).setRepoName(((BitbucketRepoJobMessage)old).getRepoName()).setRepoFullName(((BitbucketRepoJobMessage)old).getRepoFullName());
        }
        if (v instanceof BitbucketTeamJobMessage && oldMsg instanceof BitbucketTeamJobMessage) {
            newMsg = (BitbucketTeamJobMessage)v;
            old = (BitbucketTeamJobMessage)oldMsg;
            ((BitbucketTeamJobMessage)newMsg).setTeamName(((BitbucketTeamJobMessage)old).getTeamName()).setTeamId(((BitbucketTeamJobMessage)old).getTeamId()).setTeamDisplayName(((BitbucketTeamJobMessage)old).getTeamDisplayName());
        }
        if (v instanceof BitbucketJobMessage && oldMsg instanceof BitbucketJobMessage) {
            newMsg = (BitbucketJobMessage)v;
            old = (BitbucketJobMessage)oldMsg;
            newMsg.setBaseUrl(old.getBaseUrl());
        }
        return (V)v;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(BitbucketCrawler::new).execute();
    }

    public long waitDurationForRateLimit() {
        return 3600000L;
    }

    public LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> getBlockedCredentials() {
        return blockedCredentials;
    }
}

