/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.LabelUM;
import java.util.HashMap;

public class UrlPartsAggregator
implements Aggregator<LabelUM, Tag> {
    private String team;
    private String repo;

    public UrlPartsAggregator(String project, String repo) {
        this.team = project;
        this.repo = repo;
    }

    @Override
    public void populate(LabelUM um, Tag tag) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", BitbucketUtil.generateDataId(this.team, this.repo));
        urlParts.put("team", this.team);
        urlParts.put("repo", this.repo);
        urlParts.put("title", tag.getName());
        um.setUrlParts(urlParts);
    }

    private String repository() {
        return BitbucketUtil.generateDataId(this.team, this.repo);
    }
}

