/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.HttpUrl;

public class BitbucketUrlHelper {
    private static final String API_VERSION = "2.0";
    private static final String AUTHORIZED_TEAMS = "/2.0/teams?role=member&pagelen=1";
    private static final String COMMITS_SUFFIX = "?fields=values.hash,values.links.self.href,values.date";

    public static URL probeUrl(URL endPoint) throws MalformedURLException {
        return new URL(endPoint, AUTHORIZED_TEAMS);
    }

    private static URL getURL(String endPoint) throws CrawlerWorkException {
        try {
            return new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private static HttpUrl.Builder baseUrlBuilder(String endPoint) throws CrawlerWorkException {
        if (endPoint != null && !endPoint.isEmpty()) {
            URL baseURL = BitbucketUrlHelper.getURL(endPoint);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseURL.getProtocol()).host(baseURL.getHost());
            if (baseURL.getPort() != -1) {
                builder.port(baseURL.getPort());
            }
            return builder;
        }
        throw new CrawlerWorkException("Base URL can not be empty or null.");
    }

    private static HttpUrl.Builder basePathBuilder(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = BitbucketUrlHelper.baseUrlBuilder(endPoint);
        for (String path : pathSegments) {
            builder.addPathSegment(path);
        }
        return builder;
    }

    public static URL teamUrl(String endPoint, int pagelen) throws CrawlerWorkException {
        HttpUrl.Builder builder = BitbucketUrlHelper.basePathBuilder(endPoint, API_VERSION, "teams");
        return builder.addQueryParameter("pagelen", pagelen + "").addQueryParameter("role", "member").build().url();
    }

    public static URL prDataURL(String url, int pageLen) {
        return HttpUrl.parse((String)url).newBuilder().addQueryParameter("pagelen", Integer.toString(pageLen)).build().url();
    }

    private static HttpUrl.Builder filterByDate(String url, Date date) {
        String query = String.format("updated_on>%s", new SimpleDateFormat("yyyy-MM-dd").format(date));
        return HttpUrl.parse((String)url).newBuilder().addQueryParameter("q", query);
    }

    public static String allPRsUrl(String url, Date date) {
        return BitbucketUrlHelper.filterByDate(url, date).addQueryParameter("state", "all").build().url().toString();
    }

    public static URL entitiesUrl(String endPoint, int pagelen) {
        return HttpUrl.parse((String)endPoint).newBuilder().addQueryParameter("pagelen", Integer.toString(pagelen)).build().url();
    }

    public static URL commitsUrl(String endPoint) {
        return HttpUrl.parse((String)(endPoint + COMMITS_SUFFIX)).url();
    }
}

