/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;

class CommitsCache {
    private static final long KNOWN_COMMITS_CACHE_SIZE = 1000000L;
    private static final Integer THE_VOID = 0;
    private static final Cache<String, Integer> requestedCommits = CacheBuilder.newBuilder().weakKeys().concurrencyLevel(AgathaConfiguration.getCrawlerThreads()).maximumSize(1000000L).build();

    CommitsCache() {
    }

    private static String requestedCommitKey(String team, String repo, String sha) {
        return BitbucketUtil.generateDataId(team, repo, sha);
    }

    static boolean isCommitAlreadyRequested(String team, String repo, String sha) {
        return requestedCommits.getIfPresent((Object)CommitsCache.requestedCommitKey(team, repo, sha)) != null;
    }

    static void addRequestedCommit(String project, String repo, String sha) {
        requestedCommits.put((Object)CommitsCache.requestedCommitKey(project, repo, sha), (Object)THE_VOID);
    }
}

