/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.converters;

import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels.AdditionalFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels.OthersAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels.SystemFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels.UrlPartsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.BitbucketUMConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.LabelUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TagConverter
extends BitbucketUMConverter<LabelUM, Tag> {
    private String team;
    private String repo;

    public TagConverter(String TYPE, String VERSION, String PLUGIN_ID, String PLUGIN_VERSION) {
        super(TYPE, VERSION, PLUGIN_ID, PLUGIN_VERSION, DataSourceTypeEnum.LABEL);
    }

    @Override
    protected LabelUM transform(Tag entity) {
        LabelUM labelUM = new LabelUM();
        this.aggregators().forEach(aggregator -> aggregator.populate(labelUM, entity));
        return labelUM;
    }

    private List<Aggregator> aggregators() {
        return Stream.of(new SystemFieldsAggregator(this.team, this.repo), new UrlPartsAggregator(this.team, this.repo), new OthersAggregator(this.team, this.repo), new AdditionalFieldsAggregator(this.team, this.repo)).collect(Collectors.toList());
    }

    public String getTeam() {
        return this.team;
    }

    public TagConverter setTeam(String team) {
        this.team = team;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public TagConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    @Override
    protected String id(LabelUM entity) {
        return entity.getId();
    }

    @Override
    protected String version(Tag entity) {
        return TagConverter.computeHash(entity);
    }

    public static String computeHash(Tag tag) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return new BigInteger(1, md.digest((tag.getName() + "," + tag.getTarget().getHash()).getBytes("UTF-8"))).toString(16);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

