/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.helper;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.maven.helper.VersionHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;

public class ServerVersionCompatibility {
    private DeployitCommunicator communicator;
    private List<Artifact> pluginArtifacts;

    public ServerVersionCompatibility(DeployitCommunicator communicator, List<Artifact> pluginArtifacts) {
        this.communicator = communicator;
        this.pluginArtifacts = pluginArtifacts;
    }

    public void check() {
        boolean engineApiLessThanServer;
        String serverVersion = this.getServerVersion();
        VersionHelper serverVersionHelper = new VersionHelper(serverVersion);
        String serverMajor = serverVersionHelper.getMajor();
        String serverMinor = serverVersionHelper.getMinor();
        String apiVersion = this.getRemoteApiVersion();
        VersionHelper apiVersionHelper = new VersionHelper(apiVersion);
        String apiMajor = apiVersionHelper.getMajor();
        String apiMinor = apiVersionHelper.getMinor();
        boolean bl = engineApiLessThanServer = StringUtils.isEmpty((String)apiMajor) || StringUtils.isEmpty((String)serverMajor) || Integer.valueOf(apiMajor) < Integer.valueOf(serverMajor);
        if (engineApiLessThanServer) {
            String msg = String.format("Maven plugin engine-api version: '%s' is incompatible with server version: '%s'. Please use correct version of maven plugin.", apiVersion, serverVersion);
            throw new IllegalStateException(msg);
        }
    }

    private String getServerVersion() {
        ServerService serverService = this.communicator.getProxies().getServerService();
        ServerInfo serverInfo = serverService.getInfo();
        String serverVersion = serverInfo.getVersion();
        return serverVersion;
    }

    private String getRemoteApiVersion() {
        String version = "";
        for (Artifact artifact : this.pluginArtifacts) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            if (!groupId.startsWith("com.xebialabs.") || !"engine-api".equals(artifactId)) continue;
            version = artifact.getVersion();
        }
        return version;
    }
}

