package com.xebialabs.deployit.maven;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

import java.util.Collection;
import java.util.Set;

import static com.google.common.base.Preconditions.checkState;
import static com.google.common.base.Strings.isNullOrEmpty;
import static com.xebialabs.deployit.maven.helper.IdHelper.generateId;

public class ArtifactRepository {

    private Multimap<String, Artifact> repository = HashMultimap.create();

    public ArtifactRepository(MavenProject project) {
        @SuppressWarnings("unchecked")
        Set<Artifact> dependencyArtifacts = project.getArtifacts();
        if(dependencyArtifacts != null){
            for (Artifact artifact : dependencyArtifacts) {
                repository.put(generateId(artifact.getGroupId(), artifact.getArtifactId()), artifact);
            }
        }
        Artifact projectArtifact = project.getArtifact();
        if(projectArtifact != null){
            repository.put(generateId(projectArtifact.getGroupId(), projectArtifact.getArtifactId()), projectArtifact);
        }
    }

    public Artifact findSingleArtifact(String groupId, String artifactId, String type, String classifier){
        final String requestedId = generateId(groupId, artifactId);
        final String fullId = generateId(groupId, artifactId, classifier, type);
        final Collection<Artifact> candidates = repository.get(requestedId);
        Artifact winner = null;
        for (Artifact candidate : candidates) {
            if(equalsOrNotSpecified(classifier, candidate.getClassifier()) && equalsOrNotSpecified(type, candidate.getType())){
                checkState(winner == null, String.format("There are more artifacts that correspond to %s. " +
                        "Please be more specific by adding artifactType, classifier to your reference", fullId));
                winner = candidate;
            }
        }
        checkState(winner != null, String.format("There is no artifact found that matches %s", fullId));
        return winner;
    }

    private boolean equalsOrNotSpecified(String predicate, String candidateValue) {
        return isNullOrEmpty(predicate) || predicate.equals(candidateValue) ;
    }
}
