/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.util.ByteString;

public class StateTransferStartCommand
extends AbstractStateTransferCommand {
    public static final byte COMMAND_ID = 116;

    public StateTransferStartCommand() {
        this(null);
    }

    public StateTransferStartCommand(ByteString cacheName) {
        super((byte)116, cacheName);
    }

    public StateTransferStartCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super((byte)116, cacheName, topologyId, segments);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        stateProvider.startOutboundTransfer(this.origin, this.topologyId, this.segments, true);
        return CompletableFutures.completedNull();
    }

    @Override
    public String toString() {
        return "StateTransferStartCommand{topologyId=" + this.topologyId + ", segments=" + this.segments + ", cacheName=" + this.cacheName + "}";
    }
}

