/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.INameFilter;
import org.testng.xml.XmlTest;

public class JUnitMethodFinder
implements ITestMethodFinder {
    private String m_testName = null;
    private IAnnotationFinder m_annotationFinder = null;

    public JUnitMethodFinder(String string, IAnnotationFinder iAnnotationFinder) {
        this.m_testName = string;
        this.m_annotationFinder = iAnnotationFinder;
    }

    private Constructor findConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return constructor;
    }

    public ITestNGMethod[] getTestMethods(Class clazz, XmlTest xmlTest) {
        ITestNGMethod[] iTestNGMethodArray = this.privateFindTestMethods(new INameFilter(){

            @Override
            public boolean accept(ConstructorOrMethod constructorOrMethod) {
                return constructorOrMethod.getName().startsWith("test") && constructorOrMethod.getParameterTypes().length == 0;
            }
        }, clazz);
        return iTestNGMethodArray;
    }

    private ITestNGMethod[] privateFindTestMethods(INameFilter iNameFilter, Class clazz) {
        List list = Lists.newArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method : methodArray = ReflectionHelper.excludingMain(clazz2)) {
                TestNGMethod testNGMethod = new TestNGMethod(method, this.m_annotationFinder, null, null);
                ConstructorOrMethod constructorOrMethod = testNGMethod.getConstructorOrMethod();
                String string = constructorOrMethod.getName();
                if (!iNameFilter.accept(constructorOrMethod) || hashSet.contains(string)) continue;
                list.add(testNGMethod);
                hashSet.add(string);
            }
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    private static void ppp(String string) {
        System.out.println("[JUnitMethodFinder] " + string);
    }

    private Object instantiate(Class clazz) {
        Object var2_2 = null;
        Constructor constructor = this.findConstructor(clazz, new Class[]{String.class});
        try {
            if (null != constructor) {
                var2_2 = constructor.newInstance(this.m_testName);
            } else {
                constructor = clazz.getConstructor(new Class[0]);
                var2_2 = constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Couldn't find a constructor with a String parameter on your JUnit test class.");
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public ITestNGMethod[] getBeforeTestMethods(Class clazz) {
        ITestNGMethod[] iTestNGMethodArray = this.privateFindTestMethods(new INameFilter(){

            @Override
            public boolean accept(ConstructorOrMethod constructorOrMethod) {
                return "setUp".equals(constructorOrMethod.getName());
            }
        }, clazz);
        return iTestNGMethodArray;
    }

    public ITestNGMethod[] getAfterTestMethods(Class clazz) {
        ITestNGMethod[] iTestNGMethodArray = this.privateFindTestMethods(new INameFilter(){

            @Override
            public boolean accept(ConstructorOrMethod constructorOrMethod) {
                return "tearDown".equals(constructorOrMethod.getName());
            }
        }, clazz);
        return iTestNGMethodArray;
    }

    public ITestNGMethod[] getAfterClassMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeClassMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeSuiteMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterSuiteMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeGroupsConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterGroupsConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }
}

