/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport;

import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3Qa\u0004\t\u0001%YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006Q\u0001!\t!\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u0019y\u0003\u0001)A\u0005?!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0004BB\u001f\u0001A\u0003%!\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r!\u0003\u0001\u0015!\u0003A\u0011\u001dI\u0005A1A\u0005\u0002)CaA\u0014\u0001!\u0002\u0013Y\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000fU\u0003!\u0019!C\u0001\u007f!1a\u000b\u0001Q\u0001\n\u0001\u0013A#Q6lCB\u0013x\u000e^8d_2\u001cV\r\u001e;j]\u001e\u001c(BA\t\u0013\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\u0014)\u00051!/Z7pi\u0016T\u0011!F\u0001\u0005C.\\\u0017m\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\faaY8oM&<7\u0001\u0001\t\u0003A\u0019j\u0011!\t\u0006\u0003;\tR!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014\"\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\t\t\u000bu\u0011\u0001\u0019A\u0010\u0002=Q\u0013\u0018M\\:q_J$h)Y5mkJ,G)\u001a;fGR|'oQ8oM&<W#A\u0010\u0002?Q\u0013\u0018M\\:q_J$h)Y5mkJ,G)\u001a;fGR|'oQ8oM&<\u0007%A\u0016Ue\u0006t7\u000f]8si\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JLU\u000e\u001d7f[\u0016tG/\u0019;j_:\u001cE.Y:t+\u0005\u0011\u0004CA\u001a;\u001d\t!\u0004\b\u0005\u0002635\taG\u0003\u00028=\u00051AH]8pizJ!!O\r\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003se\tA\u0006\u0016:b]N\u0004xN\u001d;GC&dWO]3EKR,7\r^8s\u00136\u0004H.Z7f]R\fG/[8o\u00072\f7o\u001d\u0011\u00025Q\u0013\u0018M\\:q_J$\b*Z1si\n+\u0017\r^%oi\u0016\u0014h/\u00197\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0011\u0011,(/\u0019;j_:T!!R\r\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002H\u0005\nqa)\u001b8ji\u0016$UO]1uS>t\u0017a\u0007+sC:\u001c\bo\u001c:u\u0011\u0016\f'\u000f\u001e\"fCRLe\u000e^3sm\u0006d\u0007%A\u0007SKF,\u0018N]3D_>\\\u0017.Z\u000b\u0002\u0017B\u0011\u0001\u0004T\u0005\u0003\u001bf\u0011qAQ8pY\u0016\fg.\u0001\bSKF,\u0018N]3D_>\\\u0017.\u001a\u0011\u0002\u0019M+7-\u001e:f\u0007>|7.[3\u0016\u0003E\u00032\u0001\u0007*3\u0013\t\u0019\u0016D\u0001\u0004PaRLwN\\\u0001\u000e'\u0016\u001cWO]3D_>\\\u0017.\u001a\u0011\u0002!!\u000bg\u000eZ:iC.,G+[7f_V$\u0018!\u0005%b]\u0012\u001c\b.Y6f)&lWm\\;uA\u0001")
public class AkkaProtocolSettings {
    private final Config TransportFailureDetectorConfig;
    private final String TransportFailureDetectorImplementationClass;
    private final FiniteDuration TransportHeartBeatInterval;
    private final boolean RequireCookie;
    private final Option<String> SecureCookie;
    private final FiniteDuration HandshakeTimeout;

    public Config TransportFailureDetectorConfig() {
        return this.TransportFailureDetectorConfig;
    }

    public String TransportFailureDetectorImplementationClass() {
        return this.TransportFailureDetectorImplementationClass;
    }

    public FiniteDuration TransportHeartBeatInterval() {
        return this.TransportHeartBeatInterval;
    }

    public boolean RequireCookie() {
        return this.RequireCookie;
    }

    public Option<String> SecureCookie() {
        return this.SecureCookie;
    }

    public FiniteDuration HandshakeTimeout() {
        return this.HandshakeTimeout;
    }

    public AkkaProtocolSettings(Config config) {
        this.TransportFailureDetectorConfig = config.getConfig("akka.remote.transport-failure-detector");
        this.TransportFailureDetectorImplementationClass = this.TransportFailureDetectorConfig().getString("implementation-class");
        this.TransportHeartBeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.TransportFailureDetectorConfig()), "heartbeat-interval")), (Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.$greater((Object)Duration$.MODULE$.Zero())), (Function0 & java.io.Serializable & Serializable)() -> "transport-failure-detector.heartbeat-interval must be > 0");
        this.RequireCookie = config.getBoolean("akka.remote.require-cookie");
        this.SecureCookie = this.RequireCookie() ? new Some((Object)config.getString("akka.remote.secure-cookie")) : None$.MODULE$;
        List enabledTransports = config.getStringList("akka.remote.enabled-transports");
        this.HandshakeTimeout = enabledTransports.contains("akka.remote.netty.tcp") ? Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.netty.tcp.connection-timeout") : (enabledTransports.contains("akka.remote.netty.ssl") ? Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.netty.ssl.connection-timeout") : (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.handshake-timeout")), (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.$greater((Object)Duration$.MODULE$.Zero())), (Function0 & java.io.Serializable & Serializable)() -> "handshake-timeout must be > 0"));
    }
}

