/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.core.__builtin__;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.count$__repr___exposer;
import org.python.modules.itertools.count$count___init___exposer;
import org.python.modules.itertools.count$count___reduce___exposer;
import org.python.modules.itertools.count$exposed___new__;
import org.python.modules.itertools.count$next_exposer;

@ExposedType(name="itertools.count", base=PyObject.class, doc="count(start=0, step=1) --> count object\n\nReturn a count object whose .next() method returns consecutive values.\n  Equivalent to:\n\n      def count(firstval=0, step=1):\n      x = firstval\n      while 1:\n          yield x\n          x += step\n")
public class count
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    private PyObject counter;
    private PyObject stepper;
    private static PyObject NumberClass;
    public static final String count_doc = "count(start=0, step=1) --> count object\n\nReturn a count object whose .next() method returns consecutive values.\n  Equivalent to:\n\n      def count(firstval=0, step=1):\n      x = firstval\n      while 1:\n          yield x\n          x += step\n";

    private static synchronized PyObject getNumberClass() {
        if (NumberClass == null) {
            NumberClass = __builtin__.__import__("numbers").__getattr__("Number");
        }
        return NumberClass;
    }

    public count(PyType subType) {
        super(subType);
    }

    public count() {
        this.count___init__(Py.Zero, Py.One);
    }

    public count(PyObject start) {
        this.count___init__(start, Py.One);
    }

    public count(PyObject start, PyObject step) {
        this.count___init__(start, step);
    }

    private static PyObject getNumber(PyObject obj) {
        if (Py.isInstance(obj, count.getNumberClass())) {
            return obj;
        }
        try {
            PyObject intObj = obj.__int__();
            if (Py.isInstance(obj, count.getNumberClass())) {
                return intObj;
            }
            throw Py.TypeError("a number is required");
        }
        catch (PyException exc) {
            if (exc.match(Py.ValueError)) {
                throw Py.TypeError("a number is required");
            }
            throw exc;
        }
    }

    @ExposedNew
    final void count___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("count", args, kwds, new String[]{"start", "step"}, 0);
        PyObject start = count.getNumber(ap.getPyObject(0, Py.Zero));
        PyObject step = count.getNumber(ap.getPyObject(1, Py.One));
        this.count___init__(start, step);
    }

    private void count___init__(PyObject start, PyObject step) {
        this.counter = start;
        this.stepper = step;
        this.iter = new PyIterator(){

            @Override
            public PyObject __iternext__() {
                PyObject result2 = count.this.counter;
                count.this.counter = count.this.counter._add(count.this.stepper);
                return result2;
            }
        };
    }

    public PyObject count___copy__() {
        return new count(this.counter, this.stepper);
    }

    final PyObject count___reduce_ex__(PyObject protocol) {
        return this.__reduce_ex__(protocol);
    }

    final PyObject count___reduce__() {
        return this.__reduce_ex__(Py.Zero);
    }

    public PyObject __reduce_ex__(PyObject protocol) {
        if (this.stepper == Py.One) {
            return new PyTuple(this.getType(), new PyTuple(this.counter));
        }
        return new PyTuple(this.getType(), new PyTuple(this.counter, this.stepper));
    }

    @Override
    public PyString __repr__() {
        if (this.stepper instanceof PyInteger && this.stepper._cmp(Py.One) == 0) {
            return Py.newString(String.format("count(%s)", this.counter));
        }
        return Py.newString(String.format("count(%s, %s)", this.counter, this.stepper));
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.iter != null && (retVal = visit.visit(this.iter, arg)) != 0) {
            return retVal;
        }
        if (this.counter != null && (retVal = visit.visit(this.counter, arg)) != 0) {
            return retVal;
        }
        if (this.stepper != null && (retVal = visit.visit(this.stepper, arg)) != 0) {
            return retVal;
        }
        return super.traverse(visit, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || this.counter == ob || this.stepper == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(count.class, new count$PyExposer());
        TYPE = PyType.fromClass(count.class);
    }

    public class count$count___copy___exposer
    extends PyBuiltinMethodNarrow {
        public count$count___copy___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public count$count___copy___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new count$count___copy___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((count)this.self).count___copy__();
        }
    }

    public class count$count___reduce_ex___exposer
    extends PyBuiltinMethodNarrow {
        public count$count___reduce_ex___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public count$count___reduce_ex___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new count$count___reduce_ex___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((count)this.self).count___reduce_ex__(pyObject);
        }
    }

    public class count$PyExposer
    extends BaseTypeBuilder {
        public count$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new count$count___init___exposer("__init__"), new count$count___copy___exposer("__copy__"), new count$count___reduce_ex___exposer("__reduce_ex__"), new count$count___reduce___exposer("__reduce__"), new count$__repr___exposer("__repr__"), new count$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.count", count.class, PyObject.class, true, "count(start=0, step=1) --> count object\n\nReturn a count object whose .next() method returns consecutive values.\n  Equivalent to:\n\n      def count(firstval=0, step=1):\n      x = firstval\n      while 1:\n          yield x\n          x += step\n", pyBuiltinMethodArray, pyDataDescrArray, new count$exposed___new__());
        }
    }
}

