/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntArrayList;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class CountersManager
extends CountersReader {
    public static final int DEFAULT_TYPE_ID = 0;
    private final long freeToReuseTimeoutMs;
    private int idHighWaterMark = -1;
    private final IntArrayList freeList = new IntArrayList();
    private final EpochClock epochClock;

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset, EpochClock epochClock, long freeToReuseTimeoutMs) {
        super(metaDataBuffer, valuesBuffer, labelCharset);
        valuesBuffer.verifyAlignment();
        this.epochClock = epochClock;
        this.freeToReuseTimeoutMs = freeToReuseTimeoutMs;
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 2) {
            throw new IllegalArgumentException("Meta data buffer not sufficiently large");
        }
    }

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        super(metaDataBuffer, valuesBuffer);
        valuesBuffer.verifyAlignment();
        this.epochClock = () -> 0L;
        this.freeToReuseTimeoutMs = 0L;
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 2) {
            throw new IllegalArgumentException("Meta data buffer not sufficiently large");
        }
    }

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        this(metaDataBuffer, valuesBuffer, labelCharset, () -> 0L, 0L);
    }

    public int allocate(String label) {
        return this.allocate(label, 0);
    }

    public int allocate(String label, int typeId) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            keyFunc.accept(new UnsafeBuffer(this.metaDataBuffer, recordOffset + 16, 112));
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            int length;
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            if (null != keyBuffer) {
                length = Math.min(keyLength, 112);
                this.metaDataBuffer.putBytes(recordOffset + 16, keyBuffer, keyOffset, length);
            }
            length = Math.min(labelLength, 380);
            this.metaDataBuffer.putInt(recordOffset + 128, length);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4, labelBuffer, labelOffset, length);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public AtomicCounter newCounter(String label) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label), this);
    }

    public AtomicCounter newCounter(String label, int typeId) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId), this);
    }

    public AtomicCounter newCounter(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId, keyFunc), this);
    }

    public AtomicCounter newCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength), this);
    }

    public void free(int counterId) {
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.metaDataBuffer.putLong(recordOffset + 8, this.epochClock.time() + this.freeToReuseTimeoutMs);
        this.metaDataBuffer.putIntOrdered(recordOffset, -1);
        this.freeList.addInt(counterId);
    }

    public void setCounterValue(int counterId, long value) {
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), value);
    }

    private int nextCounterId() {
        long nowMs = this.epochClock.time();
        int size = this.freeList.size();
        for (int i = 0; i < size; ++i) {
            int counterId = this.freeList.getInt(i);
            long deadlineMs = this.metaDataBuffer.getLongVolatile(CountersManager.metaDataOffset(counterId) + 8);
            if (nowMs < deadlineMs) continue;
            this.freeList.remove(i);
            this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), 0L);
            return counterId;
        }
        return ++this.idHighWaterMark;
    }

    private void putLabel(int recordOffset, String label) {
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            int length = this.metaDataBuffer.putStringWithoutLengthAscii(recordOffset + 128 + 4, label, 0, 380);
            this.metaDataBuffer.putInt(recordOffset + 128, length);
        } else {
            byte[] bytes = label.getBytes(this.labelCharset);
            int length = Math.min(bytes.length, 380);
            this.metaDataBuffer.putInt(recordOffset + 128, length);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4, bytes, 0, length);
        }
    }

    private void checkCountersCapacity(int counterId) {
        if (CountersManager.counterOffset(counterId) + 128 > this.valuesBuffer.capacity()) {
            throw new IllegalStateException("Unable to allocate counter, values buffer is full");
        }
    }

    private void checkMetaDataCapacity(int recordOffset) {
        if (recordOffset + 512 > this.metaDataBuffer.capacity()) {
            throw new IllegalStateException("Unable to allocate counter, metadata buffer is full");
        }
    }
}

