/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.io;

import com.xebialabs.xlplatform.utils.ResourceManagement$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ZipUtils$
implements Logging {
    public static ZipUtils$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ZipUtils$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ZipUtils$ zipUtils$ = this;
        synchronized (zipUtils$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public <B> Seq<B> processEntries(InputStream zipFile, Function1<ZipInputStream, Function1<ZipEntry, B>> doStuff) {
        return (Seq)ResourceManagement$.MODULE$.using((Closeable)new ZipInputStream(zipFile), (Function1 & Serializable & scala.Serializable)zipInputStream -> {
            Function1 doThing = (Function1)doStuff.apply(zipInputStream);
            return ((Stream)package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> (ZipEntry)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> zipInputStream.getNextEntry()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZipUtils$.$anonfun$processEntries$5(x$1))).map(doThing, Stream$.MODULE$.canBuildFrom())).force();
        });
    }

    public void extract(InputStream zipFile, File dest) {
        this.collect(zipFile, dest, (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return (B1)bl;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = true;
                return bl;
            }
        });
    }

    public <A> Seq<A> collect(InputStream zipFile, File dest, PartialFunction<String, A> body) {
        dest.mkdirs();
        return (Seq)this.processEntries(zipFile, (Function1 & Serializable & scala.Serializable)zis -> (Function1 & Serializable & scala.Serializable)entry -> {
            MODULE$.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("unzip entry: ").append(entry.getName()).toString());
            String fileName = entry.getName();
            return ((Option)body.lift().apply((Object)fileName)).map((Function1 & Serializable & scala.Serializable)result -> {
                File newFile = new File(dest, fileName);
                new File(newFile.getParent()).mkdirs();
                Object object = entry.isDirectory() ? BoxesRunTime.boxToBoolean((boolean)newFile.mkdir()) : ResourceManagement$.MODULE$.using((Closeable)new FileOutputStream(newFile), (Function1 & Serializable & scala.Serializable)fos -> BoxesRunTime.boxToInteger((int)ZipUtils$.$anonfun$collect$5(zis, fos)));
                return result;
            });
        }).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public File create(Map<String, InputStream> files, File dest) {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dest));
        files.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZipUtils$.$anonfun$create$1(out, x0$1);
            return BoxedUnit.UNIT;
        });
        out.close();
        return dest;
    }

    public File archive(Seq<File> files, File dest, Option<String> stripPrefix) {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dest));
        files.foreach((Function1 & Serializable & scala.Serializable)file -> {
            ZipUtils$.$anonfun$archive$3(out, stripPrefix, file);
            return BoxedUnit.UNIT;
        });
        out.close();
        return dest;
    }

    public Option<String> archive$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$processEntries$5(ZipEntry x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ int $anonfun$collect$5(ZipInputStream zis$1, FileOutputStream fos) {
        return IOUtils.copy((InputStream)zis$1, (OutputStream)fos);
    }

    public static final /* synthetic */ void $anonfun$create$1(ZipOutputStream out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String filename = (String)tuple2._1();
        InputStream content = (InputStream)tuple2._2();
        ZipEntry entry = new ZipEntry(filename);
        out$1.putNextEntry(entry);
        IOUtils.copy((InputStream)content, (OutputStream)out$1);
        content.close();
        out$1.closeEntry();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String filename$1(File file, Option stripPrefix$1) {
        return (String)stripPrefix$1.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(file.getPath())).stripPrefix(x$2))).stripPrefix(File.separator)).getOrElse((Function0 & Serializable & scala.Serializable)() -> file.getAbsolutePath());
    }

    public static final /* synthetic */ int $anonfun$archive$4(ZipOutputStream out$2, FileInputStream content) {
        return IOUtils.copy((InputStream)content, (OutputStream)out$2);
    }

    public static final /* synthetic */ void $anonfun$archive$3(ZipOutputStream out$2, Option stripPrefix$1, File file) {
        ZipEntry entry = new ZipEntry(ZipUtils$.filename$1(file, stripPrefix$1));
        out$2.putNextEntry(entry);
        ResourceManagement$.MODULE$.using((Closeable)new FileInputStream(file), (Function1 & Serializable & scala.Serializable)content -> BoxesRunTime.boxToInteger((int)ZipUtils$.$anonfun$archive$4(out$2, content)));
        out$2.closeEntry();
    }

    private ZipUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

