/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.util;

import akka.annotation.InternalApi;
import akka.http.impl.util.ByteArrayRendering$;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.Renderer;
import akka.http.impl.util.Rendering;
import akka.http.scaladsl.model.HttpHeader;
import akka.parboiled2.CharPredicate;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=a!\u0002\u000b\u0016\u0001ei\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00115\u0002!\u0011!Q\u0001\n9BQa\u0010\u0001\u0005\u0002\u0001CQa\u0010\u0001\u0005\u0002\u0011CaA\u0012\u0001!B\u00139\u0005BB'\u0001A\u0003&!\u0006C\u0003O\u0001\u0011\u0005q\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003Q\u0001\u0011\u0005\u0001\fC\u0003Q\u0001\u0011\u00051\fC\u0003c\u0001\u0011%1\rC\u0003g\u0001\u0011\u0005q\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003k\u0001\u0011Es\rC\u0003l\u0001\u0011ECn\u0002\u0005y+\u0005\u0005\t\u0012A\rz\r!!R#!A\t\u0002eQ\b\"B \u0012\t\u0003Y\bb\u0002?\u0012#\u0003%\t! \u0002\u0013\u0005f$X-\u0011:sCf\u0014VM\u001c3fe&twM\u0003\u0002\u0017/\u0005!Q\u000f^5m\u0015\tA\u0012$\u0001\u0003j[Bd'B\u0001\u000e\u001c\u0003\u0011AG\u000f\u001e9\u000b\u0003q\tA!Y6lCN\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0016\u0013\t9SCA\u0005SK:$WM]5oO\u0006A1/\u001b>f\u0011&tGo\u0001\u0001\u0011\u0005}Y\u0013B\u0001\u0017!\u0005\rIe\u000e^\u0001\u0013Y><G)[:dCJ$W\r\u001a%fC\u0012,'\u000f\u0005\u0003 _Eb\u0014B\u0001\u0019!\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00023s9\u00111g\u000e\t\u0003i\u0001j\u0011!\u000e\u0006\u0003m%\na\u0001\u0010:p_Rt\u0014B\u0001\u001d!\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u0002\u0003CA\u0010>\u0013\tq\u0004E\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0002B\u0005\u000e\u0003\"!\n\u0001\t\u000b!\u001a\u0001\u0019\u0001\u0016\t\u000f5\u001a\u0001\u0013!a\u0001]Q\u0011\u0011)\u0012\u0005\u0006Q\u0011\u0001\rAK\u0001\u0006CJ\u0014\u0018-\u001f\t\u0004?!S\u0015BA%!\u0005\u0015\t%O]1z!\ty2*\u0003\u0002MA\t!!)\u001f;f\u0003\u0011\u0019\u0018N_3\u0002\u0007\u001d,G/F\u0001H\u00031!C/\u001b7eK\u0012\"\u0018\u000e\u001c3f)\t\u00116+D\u0001\u0001\u0011\u0015!\u0006\u00021\u0001V\u0003\u0011\u0019\u0007.\u0019:\u0011\u0005}1\u0016BA,!\u0005\u0011\u0019\u0005.\u0019:\u0015\u0005IK\u0006\"\u0002.\n\u0001\u00049\u0015!\u00022zi\u0016\u001cHC\u0001*]\u0011\u0015Q&\u00021\u0001^!\tq\u0006-D\u0001`\u0015\t12$\u0003\u0002b?\nQ!)\u001f;f'R\u0014\u0018N\\4\u0002\r\u001d\u0014xn\u001e\"z)\tQC\rC\u0003f\u0017\u0001\u0007!&A\u0003eK2$\u0018-A\tsK6\f\u0017N\\5oO\u000e\u000b\u0007/Y2jif,\u0012AK\u0001\rCN\u0014\u0015\u0010^3TiJLgnZ\u000b\u0002;\u0006!Q.\u0019:l\u0003\u0015\u0019\u0007.Z2l)\ti\u0007\u000f\u0005\u0002 ]&\u0011q\u000e\t\u0002\b\u0005>|G.Z1o\u0011\u0015Qw\u00021\u0001+Q\t\u0001!\u000f\u0005\u0002tm6\tAO\u0003\u0002v7\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]$(aC%oi\u0016\u0014h.\u00197Ba&\f!CQ=uK\u0006\u0013(/Y=SK:$WM]5oOB\u0011Q%E\n\u0003#y!\u0012!_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003yT#AL@,\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0017i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001e\u0011\n\t\u00055\u0011Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
@InternalApi
public class ByteArrayRendering
implements Rendering {
    private final Function1<String, BoxedUnit> logDiscardedHeader;
    private byte[] array;
    private int size;

    public static Function1<String, BoxedUnit> $lessinit$greater$default$2() {
        return ByteArrayRendering$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Rendering $tilde$tilde(float f) {
        return Rendering.$tilde$tilde$((Rendering)this, f);
    }

    @Override
    public Rendering $tilde$tilde(double d) {
        return Rendering.$tilde$tilde$((Rendering)this, d);
    }

    @Override
    public Rendering $tilde$tilde(int i) {
        return Rendering.$tilde$tilde$((Rendering)this, i);
    }

    @Override
    public Rendering $tilde$tilde(long l) {
        return Rendering.$tilde$tilde$((Rendering)this, l);
    }

    @Override
    public Rendering $tilde$tilde$percent(int i) {
        return Rendering.$tilde$tilde$percent$((Rendering)this, i);
    }

    @Override
    public Rendering $tilde$tilde$percent(long lng) {
        return Rendering.$tilde$tilde$percent$((Rendering)this, lng);
    }

    @Override
    public Rendering $tilde$tilde(String string) {
        return Rendering.$tilde$tilde$((Rendering)this, string);
    }

    @Override
    public Rendering $tilde$tilde(char[] chars) {
        return Rendering.$tilde$tilde$((Rendering)this, chars);
    }

    @Override
    public Rendering $tilde$tilde(HttpHeader header) {
        return Rendering.$tilde$tilde$((Rendering)this, header);
    }

    @Override
    public <T> Rendering $tilde$tilde(T value, Renderer<T> ev) {
        return Rendering.$tilde$tilde$(this, value, ev);
    }

    @Override
    public Rendering $tilde$tilde$hash(String s2) {
        return Rendering.$tilde$tilde$hash$(this, s2);
    }

    @Override
    public Rendering $tilde$tilde$hash$bang(String s2) {
        return Rendering.$tilde$tilde$hash$bang$(this, s2);
    }

    @Override
    public Rendering putEscaped(String s2, CharPredicate escape, char escChar) {
        return Rendering.putEscaped$(this, s2, escape, escChar);
    }

    @Override
    public CharPredicate putEscaped$default$2() {
        return Rendering.putEscaped$default$2$(this);
    }

    @Override
    public char putEscaped$default$3() {
        return Rendering.putEscaped$default$3$(this);
    }

    @Override
    public Rendering putReplaced(String s2, CharPredicate keep, char placeholder) {
        return Rendering.putReplaced$(this, s2, keep, placeholder);
    }

    public byte[] get() {
        if (this.size == this.array.length) {
            return this.array;
        }
        return Arrays.copyOfRange(this.array, 0, this.size);
    }

    @Override
    public ByteArrayRendering $tilde$tilde(char c) {
        int oldSize = this.growBy(1);
        this.array[oldSize] = (byte)c;
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(byte[] bytes) {
        block0: {
            if (bytes.length <= 0) break block0;
            int oldSize = this.growBy(bytes.length);
            System.arraycopy(bytes, 0, this.array, oldSize, bytes.length);
        }
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(ByteString bytes) {
        Object object;
        if (bytes.length() > 0) {
            int oldSize = this.growBy(bytes.length());
            object = BoxesRunTime.boxToInteger((int)bytes.copyToArray((Object)this.array, oldSize, bytes.length()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    private int growBy(int delta) {
        int oldSize = this.size;
        long neededSize = (long)oldSize + (long)delta;
        if ((long)this.array.length < neededSize) {
            Predef$.MODULE$.require(neededSize < Integer.MAX_VALUE, (Function0 & Serializable)() -> "Cannot create byte array greater than 2GB in size");
            int newLen = (int)package$.MODULE$.min(package$.MODULE$.max((long)this.array.length << 1, neededSize), Integer.MAX_VALUE);
            byte[] newArray = new byte[newLen];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.size = (int)neededSize;
        return oldSize;
    }

    public int remainingCapacity() {
        return this.array.length - this.size;
    }

    public ByteString asByteString() {
        return ByteString.ByteString1$.MODULE$.apply(this.array, 0, this.size);
    }

    @Override
    public int mark() {
        return this.size;
    }

    @Override
    public boolean check(int mark) {
        int origMark = mark;
        return this.rec$7(mark, origMark);
    }

    private final boolean rec$7(int mark, int origMark$2) {
        while (mark < this.size) {
            if (this.array[mark] == 13 || this.array[mark] == 10) {
                this.logDiscardedHeader.apply((Object)new StringBuilder(39).append("Invalid outgoing header was discarded. ").append(LogByteStringTools$.MODULE$.printByteString(ByteString$.MODULE$.fromArray(this.array, origMark$2, this.size - origMark$2), LogByteStringTools$.MODULE$.printByteString$default$2(), LogByteStringTools$.MODULE$.printByteString$default$3(), LogByteStringTools$.MODULE$.printByteString$default$4())).toString());
                this.size = origMark$2;
                return false;
            }
            ++mark;
        }
        return true;
    }

    public ByteArrayRendering(int sizeHint, Function1<String, BoxedUnit> logDiscardedHeader) {
        this.logDiscardedHeader = logDiscardedHeader;
        Rendering.$init$(this);
        this.array = new byte[sizeHint];
        this.size = 0;
    }

    public ByteArrayRendering(int sizeHint) {
        this(sizeHint, (Function1<String, BoxedUnit>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final void apply(String x$3) {
            }
        });
    }
}

