/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.scanner;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.ClassFile;
import nl.javadude.scannit.predicates.Predicate;
import nl.javadude.scannit.predicates.Predicates;
import nl.javadude.scannit.registry.Registry;

public abstract class AbstractScanner {
    private static final Predicate<String> INCLUDE_ALL = Predicates.alwaysTrue();
    private Predicate<String> filter = INCLUDE_ALL;

    public void addFilter(Predicate<CharSequence> filter) {
        this.filter = Predicates.and(filter, this.filter);
    }

    public void clearFilter() {
        this.filter = INCLUDE_ALL;
    }

    public boolean accepts(String name) {
        return this.filter.apply(name);
    }

    public void scan(ClassFile file, Registry registry) {
        if (this.accepts(file.getName())) {
            this.doScan(file, registry);
        }
    }

    protected abstract void doScan(ClassFile var1, Registry var2);

    protected void addToRegistry(Registry registry, String key, String descriptor) {
        Map<String, Set<String>> stringSetMap = registry.get(this);
        if (!stringSetMap.containsKey(key)) {
            stringSetMap.put(key, new HashSet());
        }
        stringSetMap.get(key).add(descriptor);
    }
}

