/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.registry.ClassExpression;
import org.jboss.resteasy.core.registry.ClassNode;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;

public class RootClassNode {
    protected ClassNode root = new ClassNode("");
    protected Map<String, ClassExpression> bounded = new HashMap<String, ClassExpression>();

    public int getSize() {
        int size = 0;
        for (ClassExpression exp : this.bounded.values()) {
            size += exp.getRoot().getSize();
        }
        return size;
    }

    public Map<String, List<ResourceInvoker>> getBounded() {
        MultivaluedHashMap invokers = new MultivaluedHashMap();
        for (ClassExpression exp : this.bounded.values()) {
            MultivaluedMap<String, ResourceInvoker> expBounded = exp.getRoot().getBounded();
            for (Map.Entry entry : expBounded.entrySet()) {
                invokers.addAll((Object)((String)entry.getKey()), (List)entry.getValue());
            }
        }
        return invokers;
    }

    public ResourceInvoker match(HttpRequest request, int start) {
        return this.root.match(request, start).match(request, start);
    }

    public void removeBinding(String classExpression, String path, Method method) {
        String regex;
        ClassExpression ce;
        if (classExpression.startsWith("/")) {
            classExpression = classExpression.substring(1);
        }
        if (classExpression.endsWith("/")) {
            classExpression = classExpression.substring(0, classExpression.length() - 1);
        }
        if ((ce = this.bounded.get(regex = new ClassExpression(classExpression).getRegex())) == null) {
            return;
        }
        ce.getRoot().removeBinding(path, method);
        if (ce.getRoot().getSize() == 0) {
            ce.getParent().targets.remove(ce);
            this.bounded.remove(regex);
        }
    }

    public void addInvoker(String classExpression, String fullpath, ResourceInvoker invoker) {
        ClassExpression newce;
        String regex;
        ClassExpression existing;
        if (classExpression.startsWith("/")) {
            classExpression = classExpression.substring(1);
        }
        if (classExpression.endsWith("/")) {
            classExpression = classExpression.substring(0, classExpression.length() - 1);
        }
        if ((existing = this.bounded.get(regex = (newce = new ClassExpression(classExpression)).getRegex())) == null) {
            newce.getRoot().addInvoker(fullpath, invoker);
            this.addExpression(classExpression, newce);
            this.bounded.put(regex, newce);
        } else {
            existing.getRoot().addInvoker(fullpath, invoker);
        }
    }

    protected void addExpression(String path, ClassExpression ce) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("".equals(path)) {
            ce.parent = this.root;
            this.root.targets.add(ce);
            return;
        }
        int expidx = path.indexOf(123);
        if (expidx > -1) {
            int i = expidx;
            while (i - 1 > -1 && path.charAt(i - 1) != '/') {
                --i;
            }
            String staticPath = null;
            if (i > 0) {
                staticPath = path.substring(0, i - 1);
            }
            ClassNode node = this.root;
            if (staticPath != null) {
                String[] split;
                for (String segment : split = staticPath.split("/")) {
                    ClassNode tmp = node.children.get(segment);
                    if (tmp == null) {
                        tmp = new ClassNode(segment);
                        node.children.put(segment, tmp);
                    }
                    node = tmp;
                }
            }
            ce.parent = node;
            node.targets.add(ce);
        } else {
            String[] split = path.split("/");
            ClassNode node = this.root;
            for (String segment : split) {
                ClassNode tmp = node.children.get(segment);
                if (tmp == null) {
                    tmp = new ClassNode(segment);
                    node.children.put(segment, tmp);
                }
                node = tmp;
            }
            ce.parent = node;
            node.targets.add(ce);
        }
    }
}

