/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.CompositeCertificateException;
import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001D\u0007\u0001-!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!q\u0004A!A!\u0002\u0013y\u0004\"B\"\u0001\t\u0003!\u0005bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000bu\u0003A\u0011\u00010\t\u000b9\u0004A\u0011A8\t\u000bI\u0004A\u0011B:\t\u000bu\u0004A\u0011\t@\u00033\r{W\u000e]8tSR,\u0007,\u000e\u0019:)J,8\u000f^'b]\u0006<WM\u001d\u0006\u0003\u001d=\t1a]:m\u0015\t\u0001\u0012#A\u0005tg2\u001cwN\u001c4jO*\u0011!cE\u0001\tif\u0004Xm]1gK*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/}\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004PE*,7\r\u001e\t\u0003A\u0019j\u0011!\t\u0006\u0003\u001d\tR!a\t\u0013\u0002\u00079,GOC\u0001&\u0003\u0015Q\u0017M^1y\u0013\t9\u0013E\u0001\tYkAJDK];ti6\u000bg.Y4fe\u0006AQn\u001b'pO\u001e,'\u000f\u0005\u0002+[5\t1F\u0003\u0002-\u001f\u0005!Q\u000f^5m\u0013\tq3FA\u0007M_\u001e<WM\u001d$bGR|'/_\u0001\u000eiJ,8\u000f^'b]\u0006<WM]:\u0011\u0007EZtD\u0004\u00023q9\u00111GN\u0007\u0002i)\u0011Q'F\u0001\u0007yI|w\u000e\u001e \n\u0003]\nQa]2bY\u0006L!!\u000f\u001e\u0002\u000fA\f7m[1hK*\tq'\u0003\u0002={\t\u00191+Z9\u000b\u0005eR\u0014\u0001E1mO>\u0014\u0018\u000e\u001e5n\u0007\",7m[3s!\t\u0001\u0015)D\u0001\u000e\u0013\t\u0011UB\u0001\tBY\u001e|'/\u001b;i[\u000eCWmY6fe\u00061A(\u001b8jiz\"B!\u0012$H\u0011B\u0011\u0001\t\u0001\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006}\u0011\u0001\raP\u0001\u0007Y><w-\u001a:\u0016\u0003-\u0003\"A\u000b'\n\u00055[#\u0001\u0004(p\t\u0016\u00048\u000fT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0013O\u0016$\u0018iY2faR,G-S:tk\u0016\u00148\u000fF\u0001R!\r\u00116+V\u0007\u0002u%\u0011AK\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bAaY3si*\u0011!lG\u0001\tg\u0016\u001cWO]5us&\u0011Al\u0016\u0002\u00101V\u0002\u0014hQ3si&4\u0017nY1uK\u0006\u00112\r[3dW\u000ec\u0017.\u001a8u)J,8\u000f^3e)\ry&\r\u001a\t\u0003%\u0002L!!\u0019\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006G\"\u0001\r!U\u0001\u0006G\"\f\u0017N\u001c\u0005\u0006K\"\u0001\rAZ\u0001\tCV$\b\u000eV=qKB\u0011qm\u001b\b\u0003Q&\u0004\"a\r\u001e\n\u0005)T\u0014A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\u001e\u0002%\rDWmY6TKJ4XM\u001d+skN$X\r\u001a\u000b\u0004?B\f\b\"B2\n\u0001\u0004\t\u0006\"B3\n\u0001\u00041\u0017!E<ji\"$&/^:u\u001b\u0006t\u0017mZ3sgR\u0011A\u000f\u001f\t\u0004cm*\bCA\u0019w\u0013\t9XHA\u0005UQJ|w/\u00192mK\")\u0011P\u0003a\u0001u\u0006)!\r\\8dWB!!k_\u0010`\u0013\ta(HA\u0005Gk:\u001cG/[8oc\u0005AAo\\*ue&tw\rF\u0001g\u0001")
public class CompositeX509TrustManager
implements X509TrustManager {
    private final Seq<X509TrustManager> trustManagers;
    private final AlgorithmChecker algorithmChecker;
    private final NoDepsLogger logger;

    private NoDepsLogger logger() {
        return this.logger;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        this.logger().debug("getAcceptedIssuers: ");
        ArrayBuffer certificates = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable)trustManager -> {
            certificates.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])trustManager.getAcceptedIssuers()));
            return BoxedUnit.UNIT;
        });
        if (!exceptionList.isEmpty()) {
            String msg = ((Throwable)exceptionList.apply(0)).getMessage();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
        return (X509Certificate[])certificates.toArray(ClassTag$.MODULE$.apply(X509Certificate.class));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        this.logger().debug(new StringBuilder(28).append("checkClientTrusted: chain = ").append(package$.MODULE$.debugChain(chain)).toString());
        TrustAnchor anchor = new TrustAnchor(chain[chain.length - 1], null);
        this.logger().debug(new StringBuilder(58).append("checkClientTrusted: checking key size only on root anchor ").append(anchor).toString());
        this.algorithmChecker.checkKeyAlgorithms(anchor.getTrustedCert());
        BooleanRef trusted = BooleanRef.create((boolean)false);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable)trustManager -> {
            CompositeX509TrustManager.$anonfun$checkClientTrusted$1(this, chain, authType, trusted, trustManager);
            return BoxedUnit.UNIT;
        });
        if (!trusted.elem) {
            String msg = "No trust manager was able to validate this certificate chain.";
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        this.logger().debug(new StringBuilder(41).append("checkServerTrusted: chain = ").append(package$.MODULE$.debugChain(chain)).append(", authType = ").append(authType).toString());
        TrustAnchor anchor = new TrustAnchor(chain[chain.length - 1], null);
        this.logger().debug(new StringBuilder(58).append("checkServerTrusted: checking key size only on root anchor ").append(anchor).toString());
        this.algorithmChecker.checkKeyAlgorithms(anchor.getTrustedCert());
        BooleanRef trusted = BooleanRef.create((boolean)false);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable)trustManager -> {
            CompositeX509TrustManager.$anonfun$checkServerTrusted$1(this, chain, authType, trusted, trustManager);
            return BoxedUnit.UNIT;
        });
        if (!trusted.elem) {
            String msg = new StringBuilder(80).append("No trust manager was able to validate this certificate chain: # of exceptions = ").append(exceptionList.size()).toString();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    private Seq<Throwable> withTrustManagers(Function1<X509TrustManager, BoxedUnit> block) {
        ArrayBuffer exceptionList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.trustManagers.foreach((Function1 & Serializable)trustManager -> {
            Object object;
            try {
                object = block.apply(trustManager);
            }
            catch (Throwable throwable) {
                Option option;
                Buffer buffer;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CertPathBuilderException) {
                    CertPathBuilderException certPathBuilderException = (CertPathBuilderException)throwable2;
                    this.logger().debug(new StringBuilder(90).append("No path found to certificate: this usually means the CA is not in the trust store. Cause: ").append(certPathBuilderException).toString());
                    buffer = exceptionList.append((Object)certPathBuilderException);
                } else if (throwable2 instanceof GeneralSecurityException) {
                    GeneralSecurityException generalSecurityException = (GeneralSecurityException)throwable2;
                    this.logger().debug(new StringBuilder(35).append("General security exception. Cause: ").append(generalSecurityException).toString());
                    buffer = exceptionList.append((Object)generalSecurityException);
                } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logger().debug(new StringBuilder(29).append("Unexpected exception! Cause: ").append(e).toString());
                    buffer = exceptionList.append((Object)e);
                } else {
                    throw throwable;
                }
                object = buffer;
            }
            return object;
        });
        return exceptionList.toSeq();
    }

    public String toString() {
        return new StringBuilder(66).append("CompositeX509TrustManager(trustManagers = [").append(this.trustManagers).append("], algorithmChecker = ").append(this.algorithmChecker).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$checkClientTrusted$1(CompositeX509TrustManager $this, X509Certificate[] chain$1, String authType$1, BooleanRef trusted$1, X509TrustManager trustManager) {
        trustManager.checkClientTrusted(chain$1, authType$1);
        $this.logger().debug(new StringBuilder(52).append("checkClientTrusted: trustManager ").append(trustManager).append(" found a match for ").append(package$.MODULE$.debugChain(chain$1)).toString());
        trusted$1.elem = true;
    }

    public static final /* synthetic */ void $anonfun$checkServerTrusted$1(CompositeX509TrustManager $this, X509Certificate[] chain$2, String authType$2, BooleanRef trusted$2, X509TrustManager trustManager) {
        trustManager.checkServerTrusted(chain$2, authType$2);
        $this.logger().debug(new StringBuilder(68).append("checkServerTrusted: trustManager ").append(trustManager).append(" using authType ").append(authType$2).append(" found a match for ").append(package$.MODULE$.debugChain(chain$2).toSeq()).toString());
        trusted$2.elem = true;
    }

    public CompositeX509TrustManager(LoggerFactory mkLogger, Seq<X509TrustManager> trustManagers, AlgorithmChecker algorithmChecker) {
        this.trustManagers = trustManagers;
        this.algorithmChecker = algorithmChecker;
        this.logger = mkLogger.apply(this.getClass());
    }
}

