/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.util.StringUtils;

public class AwsParameterStoreEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsParameterStoreEnvironmentRepository, AwsParameterStoreEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsParameterStoreEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsParameterStoreEnvironmentRepository build(AwsParameterStoreEnvironmentProperties environmentProperties) {
        AWSSimpleSystemsManagementClientBuilder clientBuilder = AWSSimpleSystemsManagementClientBuilder.standard();
        String region = environmentProperties.getRegion();
        if (StringUtils.hasLength((String)region)) {
            Regions awsRegion = Regions.fromName((String)region);
            clientBuilder.withRegion(awsRegion);
            String endpoint = environmentProperties.getEndpoint();
            if (StringUtils.hasLength((String)endpoint)) {
                AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(endpoint, awsRegion.getName());
                clientBuilder.withEndpointConfiguration(endpointConfiguration);
            }
        }
        AWSSimpleSystemsManagement client = (AWSSimpleSystemsManagement)clientBuilder.build();
        return new AwsParameterStoreEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

