/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public final class JdbcNodeManager
extends NodeManager {
    private static final Logger LOGGER = Logger.getLogger(JdbcNodeManager.class);
    private static final long MAX_PAUSE_MILLIS = 2000L;
    private final Supplier<? extends SharedStateManager> sharedStateManagerFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledLiveLockFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledBackupLockFactory;
    private SharedStateManager sharedStateManager;
    private ScheduledLeaseLock scheduledLiveLock;
    private ScheduledLeaseLock scheduledBackupLock;
    private final long lockAcquisitionTimeoutMillis;
    private volatile boolean interrupted = false;
    private final LeaseLock.Pauser pauser;

    public static JdbcNodeManager with(DatabaseStorageConfiguration configuration, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        JdbcNodeManager.validateTimeoutConfiguration(configuration);
        Object sqlProviderFactory = configuration.getSqlProviderFactory() != null ? configuration.getSqlProviderFactory() : new PropertySQLProvider.Factory(configuration.getConnectionProvider());
        String brokerId = UUID.randomUUID().toString();
        return JdbcNodeManager.usingConnectionProvider(brokerId, configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getConnectionProvider(), sqlProviderFactory.create(configuration.getNodeManagerStoreTableName(), SQLProvider.DatabaseStoreType.NODE_MANAGER), scheduledExecutorService, executorFactory);
    }

    private static JdbcNodeManager usingConnectionProvider(String brokerId, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, JDBCConnectionProvider connectionProvider, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingConnectionProvider(brokerId, lockExpirationMillis, lockRenewPeriodMillis, connectionProvider, provider), lockExpirationMillis, lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory);
    }

    private static void validateTimeoutConfiguration(DatabaseStorageConfiguration configuration) {
        long lockExpiration = configuration.getJdbcLockExpirationMillis();
        if (lockExpiration <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-expiration should be positive");
        }
        long lockRenewPeriod = configuration.getJdbcLockRenewPeriodMillis();
        if (lockRenewPeriod <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be positive");
        }
        if (lockRenewPeriod >= lockExpiration) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be < jdbc-lock-expiration");
        }
        int networkTimeout = configuration.getJdbcNetworkTimeout();
        if (networkTimeout >= 0) {
            if ((long)networkTimeout > lockExpiration) {
                LOGGER.warn((Object)"jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
            }
        } else {
            LOGGER.warn((Object)"jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
        }
    }

    private JdbcNodeManager(Supplier<? extends SharedStateManager> sharedStateManagerFactory, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        super(false);
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
        this.pauser = LeaseLock.Pauser.sleep(Math.min(lockRenewPeriodMillis, 2000L), TimeUnit.MILLISECONDS);
        this.sharedStateManagerFactory = sharedStateManagerFactory;
        this.scheduledLiveLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "live", this.sharedStateManager.liveLock(), lockRenewPeriodMillis, this::notifyLostLock);
        this.scheduledBackupLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "backup", this.sharedStateManager.backupLock(), lockRenewPeriodMillis, this::notifyLostLock);
        this.sharedStateManager = null;
        this.scheduledLiveLock = null;
        this.scheduledBackupLock = null;
    }

    @Override
    protected synchronized void notifyLostLock() {
        try {
            super.notifyLostLock();
        }
        finally {
            if (!this.isStarted()) {
                return;
            }
            try {
                this.stop();
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Stopping node manager has errored on lost lock notification", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        try {
            if (this.isStarted()) {
                return;
            }
            this.sharedStateManager = this.sharedStateManagerFactory.get();
            LOGGER.debug((Object)"setup sharedStateManager on start");
            org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.setup(() -> ((UUIDGenerator)UUIDGenerator.getInstance()).generateUUID());
            this.setUUID(nodeId);
            this.scheduledLiveLock = this.scheduledLiveLockFactory.get();
            this.scheduledBackupLock = this.scheduledBackupLockFactory.get();
            super.start();
        }
        catch (IllegalStateException e) {
            this.sharedStateManager = null;
            this.scheduledLiveLock = null;
            this.scheduledBackupLock = null;
            throw e;
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            try {
                this.scheduledLiveLock.stop();
                this.scheduledBackupLock.stop();
            }
            finally {
                super.stop();
                this.sharedStateManager.close();
                this.sharedStateManager = null;
                this.scheduledLiveLock = null;
                this.scheduledBackupLock = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws NodeManager.NodeManagerException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER isAwaitingFailback");
        try {
            boolean bl = this.readSharedState() == SharedStateManager.State.FAILING_BACK;
            return bl;
        }
        catch (IllegalStateException e) {
            LOGGER.warn((Object)"cannot retrieve the live state: assume it's not yet failed back", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            LOGGER.debug((Object)"EXIT isAwaitingFailback");
        }
    }

    @Override
    public boolean isBackupLive() throws NodeManager.NodeManagerException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER isBackupLive");
        try {
            boolean bl = this.scheduledLiveLock.lock().isHeld();
            return bl;
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            LOGGER.debug((Object)"EXIT isBackupLive");
        }
    }

    @Override
    public void interrupt() {
        LOGGER.debug((Object)"ENTER interrupted");
        this.interrupted = true;
        LOGGER.debug((Object)"EXIT interrupted");
    }

    @Override
    public void releaseBackup() throws NodeManager.NodeManagerException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER releaseBackup");
        try {
            if (this.scheduledBackupLock.isStarted()) {
                LOGGER.debug((Object)"scheduledBackupLock is running: stop it and release backup lock");
                this.scheduledBackupLock.stop();
                this.scheduledBackupLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledBackupLock is not running");
            }
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            LOGGER.debug((Object)"EXIT releaseBackup");
        }
    }

    private void lock(LeaseLock lock) throws ActiveMQLockAcquisitionTimeoutException, InterruptedException {
        long lockAcquisitionTimeoutNanos = this.lockAcquisitionTimeoutMillis >= 0L ? TimeUnit.MILLISECONDS.toNanos(this.lockAcquisitionTimeoutMillis) : -1L;
        Enum acquireResult = null;
        long start = System.nanoTime();
        while (acquireResult == null) {
            this.checkStarted();
            long remainingNanos = JdbcNodeManager.remainingNanos(start, lockAcquisitionTimeoutNanos);
            if (remainingNanos == 0L) {
                acquireResult = LeaseLock.AcquireResult.Timeout;
                continue;
            }
            long remainingMillis = remainingNanos > 0L ? TimeUnit.NANOSECONDS.toMillis(remainingNanos) : -1L;
            try {
                acquireResult = lock.tryAcquire(remainingMillis, this.pauser, () -> !this.interrupted);
            }
            catch (IllegalStateException e) {
                LOGGER.warn((Object)"Errored while trying to acquire lock", (Throwable)e);
                if (JdbcNodeManager.remainingNanos(start, lockAcquisitionTimeoutNanos) == 0L) {
                    acquireResult = LeaseLock.AcquireResult.Timeout;
                    continue;
                }
                this.pauser.idle();
            }
        }
        switch (2.$SwitchMap$org$apache$activemq$artemis$core$server$impl$jdbc$LeaseLock$AcquireResult[acquireResult.ordinal()]) {
            case 1: {
                throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
            }
            case 2: {
                this.interrupted = false;
                throw new InterruptedException("LeaseLock was interrupted");
            }
            case 3: {
                break;
            }
            default: {
                throw new AssertionError((Object)((LeaseLock.AcquireResult)acquireResult + " not managed"));
            }
        }
    }

    private static long remainingNanos(long start, long timeoutNanos) {
        if (timeoutNanos > 0L) {
            long elapsedNanos = System.nanoTime() - start;
            if (elapsedNanos < timeoutNanos) {
                return timeoutNanos - elapsedNanos;
            }
            return 0L;
        }
        assert (timeoutNanos == -1L);
        return -1L;
    }

    private void checkInterrupted(Supplier<String> message) throws InterruptedException {
        if (this.interrupted) {
            this.interrupted = false;
            throw new InterruptedException(message.get());
        }
    }

    private void renewLock(ScheduledLeaseLock lock) {
        boolean lostLock = true;
        IllegalStateException renewEx = null;
        try {
            lostLock = !this.scheduledLiveLock.lock().renew();
        }
        catch (IllegalStateException e) {
            renewEx = e;
        }
        if (lostLock) {
            this.notifyLostLock();
            if (renewEx == null) {
                renewEx = new IllegalStateException(lock.lockName() + " lock isn't renewed");
            }
            throw renewEx;
        }
    }

    private boolean lockLiveAndCheckLiveState() throws ActiveMQLockAcquisitionTimeoutException, InterruptedException {
        this.lock(this.scheduledLiveLock.lock());
        while (true) {
            long localExpirationTime;
            try {
                SharedStateManager.State stateWhileLocked = this.readSharedState();
                localExpirationTime = this.scheduledLiveLock.lock().localExpirationTime();
                if (System.currentTimeMillis() > localExpirationTime) {
                    return false;
                }
                if (stateWhileLocked == SharedStateManager.State.LIVE) {
                    return true;
                }
                this.scheduledLiveLock.lock().release();
                return false;
            }
            catch (IllegalStateException e) {
                LOGGER.error((Object)"error while holding the live node lock and tried to read the shared state or to release the lock", (Throwable)e);
                this.checkStarted();
                this.checkInterrupted(() -> "interrupt on error while checking live state");
                this.pauser.idle();
                localExpirationTime = this.scheduledLiveLock.lock().localExpirationTime();
                if (System.currentTimeMillis() <= localExpirationTime) continue;
                return false;
            }
            break;
        }
    }

    @Override
    public void awaitLiveNode() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER awaitLiveNode");
        try {
            boolean liveWhileLocked = false;
            while (!liveWhileLocked) {
                SharedStateManager.State state = null;
                try {
                    state = this.readSharedState();
                }
                catch (IllegalStateException e) {
                    LOGGER.warn((Object)"Errored while reading shared state", (Throwable)e);
                }
                if (state == SharedStateManager.State.LIVE) {
                    liveWhileLocked = this.lockLiveAndCheckLiveState();
                } else {
                    LOGGER.debugf("state while awaiting live node: %s", (Object)state);
                }
                if (liveWhileLocked) continue;
                this.checkStarted();
                this.checkInterrupted(() -> "awaitLiveNode got interrupted!");
                this.pauser.idle();
            }
            LOGGER.debugf("acquired live node lock while state is %s: starting scheduledLiveLock", (Object)SharedStateManager.State.LIVE);
            this.scheduledLiveLock.start();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            LOGGER.debug((Object)"EXIT awaitLiveNode");
        }
    }

    @Override
    public void startBackup() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER startBackup");
        try {
            ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
            this.lock(this.scheduledBackupLock.lock());
            this.scheduledBackupLock.start();
            ActiveMQServerLogger.LOGGER.gotBackupLock();
            if (this.getUUID() == null) {
                this.readNodeId();
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            LOGGER.debug((Object)"EXIT startBackup");
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER startLiveNode");
        try {
            boolean done = false;
            while (!done) {
                try {
                    this.setFailingBack();
                    done = true;
                }
                catch (IllegalStateException e) {
                    LOGGER.warn((Object)"cannot set failing back state, retry", (Throwable)e);
                    this.pauser.idle();
                    this.checkInterrupted(() -> "interrupt while trying to set failing back state");
                }
            }
            String timeoutMessage = this.lockAcquisitionTimeoutMillis == -1L ? "indefinitely" : this.lockAcquisitionTimeoutMillis + " milliseconds";
            ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
            this.lock(this.scheduledLiveLock.lock());
            this.scheduledLiveLock.start();
            ActiveMQServerLogger.LOGGER.obtainedLiveLock();
            CleaningActivateCallback cleaningActivateCallback = new CleaningActivateCallback(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void activationComplete() {
                    LOGGER.debug((Object)"ENTER activationComplete");
                    try {
                        boolean done = false;
                        while (!done) {
                            try {
                                JdbcNodeManager.this.setLive();
                                done = true;
                            }
                            catch (IllegalStateException e) {
                                LOGGER.warn((Object)"Errored while trying to setLive", (Throwable)e);
                                JdbcNodeManager.this.checkStarted();
                                JdbcNodeManager.this.pauser.idle();
                                long localExpirationTime = JdbcNodeManager.this.scheduledLiveLock.lock().localExpirationTime();
                                if (System.currentTimeMillis() <= localExpirationTime) continue;
                                throw new IllegalStateException("live lock is probably expired: failed to setLive");
                                return;
                            }
                        }
                    }
                    catch (IllegalStateException e) {
                        ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                        throw new NodeManager.NodeManagerException(e);
                    }
                    finally {
                        LOGGER.debug((Object)"EXIT activationComplete");
                    }
                }
            };
            return cleaningActivateCallback;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            LOGGER.debug((Object)"EXIT startLiveNode");
        }
    }

    @Override
    public void pauseLiveServer() throws NodeManager.NodeManagerException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER pauseLiveServer");
        try {
            if (this.scheduledLiveLock.isStarted()) {
                LOGGER.debug((Object)"scheduledLiveLock is running: set paused shared state, stop it and release live lock");
                this.setPaused();
                this.scheduledLiveLock.stop();
                this.scheduledLiveLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledLiveLock is not running: try renew live lock");
                this.renewLock(this.scheduledLiveLock);
                LOGGER.debug((Object)"live lock renewed: set paused shared state and release live lock");
                this.setPaused();
                this.scheduledLiveLock.lock().release();
            }
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            LOGGER.debug((Object)"EXIT pauseLiveServer");
        }
    }

    @Override
    public void crashLiveServer() throws NodeManager.NodeManagerException {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER crashLiveServer");
        try {
            if (this.scheduledLiveLock.isStarted()) {
                LOGGER.debug((Object)"scheduledLiveLock is running: request stop it and release live lock");
                this.scheduledLiveLock.stop();
                this.scheduledLiveLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledLiveLock is not running");
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT crashLiveServer");
        }
    }

    @Override
    public void awaitLiveStatus() {
        this.checkStarted();
        LOGGER.debug((Object)"ENTER awaitLiveStatus");
        try {
            SharedStateManager.State state = null;
            while (state != SharedStateManager.State.LIVE) {
                try {
                    state = this.readSharedState();
                }
                catch (IllegalStateException e) {
                    LOGGER.warn((Object)"Errored while trying to read shared state", (Throwable)e);
                }
                this.pauser.idle();
                this.checkStarted();
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT awaitLiveStatus");
        }
    }

    private void setLive() {
        this.writeSharedState(SharedStateManager.State.LIVE);
    }

    private void setFailingBack() {
        this.writeSharedState(SharedStateManager.State.FAILING_BACK);
    }

    private void setPaused() {
        this.writeSharedState(SharedStateManager.State.PAUSED);
    }

    private void writeSharedState(SharedStateManager.State state) {
        LOGGER.debugf("writeSharedState state = %s", (Object)state);
        this.sharedStateManager.writeState(state);
    }

    private SharedStateManager.State readSharedState() {
        SharedStateManager.State state = this.sharedStateManager.readState();
        LOGGER.debugf("readSharedState state = %s", (Object)state);
        return state;
    }

    @Override
    public SimpleString readNodeId() {
        this.checkStarted();
        org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.readNodeId();
        LOGGER.debugf("readNodeId nodeId = %s", (Object)nodeId);
        this.setUUID(nodeId);
        return this.getNodeId();
    }
}

