/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationPolicySet;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationStreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.federation.AbstractFederationStream;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddress;
import org.apache.activemq.artemis.core.server.federation.queue.FederatedQueue;

public class FederationUpstream
extends AbstractFederationStream {
    private FederationUpstreamConfiguration config;

    public FederationUpstream(ActiveMQServer server, Federation federation, String name, FederationUpstreamConfiguration config) {
        super(server, federation, name, (FederationStreamConfiguration)config);
        this.config = config;
    }

    @Override
    public synchronized void start() {
        super.start();
        for (FederatedQueue federatedQueue : this.federatedQueueMap.values()) {
            federatedQueue.start();
        }
        for (FederatedAddress federatedAddress : this.federatedAddressMap.values()) {
            federatedAddress.start();
        }
        this.callFederationStreamStartedPlugins();
    }

    @Override
    public synchronized void stop() {
        for (FederatedAddress federatedAddress : this.federatedAddressMap.values()) {
            federatedAddress.stop();
        }
        this.federatedAddressMap.clear();
        for (FederatedQueue federatedQueue : this.federatedQueueMap.values()) {
            federatedQueue.stop();
        }
        this.federatedQueueMap.clear();
        super.stop();
        this.callFederationStreamStoppedPlugins();
    }

    public void deploy(Set<String> policyRefsToDeploy, Map<String, FederationPolicy> policyMap) throws ActiveMQException {
        this.deployPolicyRefs(policyRefsToDeploy, policyMap, 0);
    }

    private void deployPolicyRefs(Set<String> policyRefsToDeploy, Map<String, FederationPolicy> policyMap, int recursionDepth) throws ActiveMQException {
        for (String policyRef : policyRefsToDeploy) {
            FederationPolicy policy = policyMap.get(policyRef);
            if (policy != null) {
                if (policy instanceof FederationPolicySet) {
                    FederationPolicySet federationPolicySet = (FederationPolicySet)policy;
                    if (recursionDepth < 10) {
                        this.deployPolicyRefs(federationPolicySet.getPolicyRefs(), policyMap, ++recursionDepth);
                        continue;
                    }
                    ActiveMQServerLogger.LOGGER.federationAvoidStackOverflowPolicyRef(this.name.toString(), policyRef);
                    continue;
                }
                if (policy instanceof FederationQueuePolicyConfiguration) {
                    this.deploy((FederationQueuePolicyConfiguration)policy);
                    continue;
                }
                if (policy instanceof FederationAddressPolicyConfiguration) {
                    this.deploy((FederationAddressPolicyConfiguration)policy);
                    continue;
                }
                ActiveMQServerLogger.LOGGER.federationUnknownPolicyType(this.name.toString(), policyRef);
                continue;
            }
            ActiveMQServerLogger.LOGGER.federationCantFindPolicyRef(this.name.toString(), policyRef);
        }
    }

    public synchronized boolean deploy(FederationQueuePolicyConfiguration federatedQueueConfig) throws ActiveMQException {
        String name = federatedQueueConfig.getName();
        FederatedQueue existing = (FederatedQueue)this.federatedQueueMap.get(name);
        if (existing == null || !existing.getConfig().equals((Object)federatedQueueConfig)) {
            this.undeployQueue(name);
            FederatedQueue federatedQueue = new FederatedQueue(this.federation, federatedQueueConfig, this.server, this);
            this.federatedQueueMap.put(name, federatedQueue);
            this.federation.register(federatedQueue);
            if (this.connection.isStarted()) {
                federatedQueue.start();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean deploy(FederationAddressPolicyConfiguration federatedAddressConfig) throws ActiveMQException {
        String name = federatedAddressConfig.getName();
        FederatedAddress existing = (FederatedAddress)this.federatedAddressMap.get(name);
        if (existing == null || !existing.getConfig().equals((Object)federatedAddressConfig)) {
            this.undeployAddress(name);
            FederatedAddress federatedAddress = new FederatedAddress(this.federation, federatedAddressConfig, this.server, this);
            this.federatedAddressMap.put(name, federatedAddress);
            this.federation.register(federatedAddress);
            if (this.connection.isStarted()) {
                federatedAddress.start();
            }
            return true;
        }
        return false;
    }

    private void undeployAddress(String name) {
        FederatedAddress federatedAddress = (FederatedAddress)this.federatedAddressMap.remove(name);
        if (federatedAddress != null) {
            federatedAddress.stop();
            this.federation.unregister(federatedAddress);
        }
    }

    private void undeployQueue(String name) {
        FederatedQueue federatedQueue = (FederatedQueue)this.federatedQueueMap.remove(name);
        if (federatedQueue != null) {
            federatedQueue.stop();
            this.federation.unregister(federatedQueue);
        }
    }

    public FederationUpstreamConfiguration getConfig() {
        return this.config;
    }
}

