/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;

public class PathSegmentImpl
implements PathSegment {
    private String path;
    private String original;
    private MultivaluedMap<String, String> matrixParameters;
    private boolean hasMatrixParams;

    public PathSegmentImpl(String segment, boolean decode) {
        this.original = segment;
        this.path = segment;
        int semicolon = segment.indexOf(59);
        if (semicolon >= 0) {
            String[] params;
            this.matrixParameters = new MultivaluedMapImpl<String, String>();
            this.hasMatrixParams = true;
            this.path = semicolon > 0 ? segment.substring(0, semicolon) : "";
            String matrixParams = segment.substring(semicolon + 1);
            for (String param : params = matrixParams.split(";")) {
                String[] namevalue = param.split("=");
                if (namevalue == null || namevalue.length <= 0) continue;
                String name = namevalue[0];
                if (decode) {
                    name = Encode.decodePath(name);
                }
                String value = null;
                if (namevalue.length > 1) {
                    value = namevalue[1];
                }
                if (decode && value != null) {
                    value = Encode.decodePath(value);
                }
                this.matrixParameters.add((Object)name, (Object)value);
            }
        }
        if (decode) {
            this.path = Encode.decodePath(this.path);
        }
    }

    public boolean hasMatrixParams() {
        return this.hasMatrixParams;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getPath() {
        return this.path;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.matrixParameters == null) {
            this.matrixParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.matrixParameters;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.path != null) {
            buf.append(this.path);
        }
        if (this.matrixParameters != null) {
            for (String name : this.matrixParameters.keySet()) {
                for (String value : (List)this.matrixParameters.get((Object)name)) {
                    buf.append(";").append(name).append("=").append(value);
                }
            }
        }
        return buf.toString();
    }

    public static List<PathSegment> parseSegments(String path, boolean decode) {
        return PathSegmentImpl.parseSegmentsOptimization((String)path, (boolean)decode).segments;
    }

    public static SegmentParse parseSegmentsOptimization(String path, boolean decode) {
        SegmentParse parse = new SegmentParse();
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        parse.segments = pathSegments;
        int start = 0;
        if (path.startsWith("/")) {
            ++start;
        }
        int length = path.length();
        do {
            String p;
            int slash;
            if ((slash = path.indexOf(47, start)) < 0) {
                p = path.substring(start);
                start = length;
            } else {
                p = path.substring(start, slash);
                start = slash + 1;
            }
            PathSegmentImpl pathSegment = new PathSegmentImpl(p, decode);
            parse.hasMatrixParams |= pathSegment.hasMatrixParams();
            pathSegments.add(pathSegment);
        } while (start < length);
        return parse;
    }

    public static class SegmentParse {
        public List<PathSegment> segments;
        public boolean hasMatrixParams;
    }
}

