/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.util.FindAnnotation;
import org.jboss.resteasy.spi.util.MethodHashing;

public class PropertyInjectorImpl
implements PropertyInjector {
    protected HashMap<Field, ValueInjector> fieldMap = new HashMap();
    protected List<SetterMethod> setters = new ArrayList<SetterMethod>();
    protected HashMap<Long, Method> setterhashes = new HashMap();
    protected Class<?> clazz;

    public PropertyInjectorImpl(Class<?> clazz, ResteasyProviderFactory factory) {
        this.clazz = clazz;
        this.populateMap(clazz, factory);
    }

    protected void populateMap(Class<?> clazz, ResteasyProviderFactory factory) {
        Type genericType;
        Class<?> type;
        Annotation[] annotations;
        for (Field field : this.getDeclaredFields(clazz)) {
            annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0) continue;
            type = field.getType();
            genericType = field.getGenericType();
            ValueInjector extractor = this.getParameterExtractor(clazz, factory, field, field.getName(), annotations, type, genericType);
            if (extractor == null) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                this.setAccessible(field);
            }
            this.fieldMap.put(field, extractor);
        }
        for (AccessibleObject accessibleObject : this.getDeclaredMethods(clazz)) {
            Method older;
            if (!((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1 || (annotations = accessibleObject.getAnnotations()) == null || annotations.length == 0) continue;
            type = ((Method)accessibleObject).getParameterTypes()[0];
            genericType = ((Method)accessibleObject).getGenericParameterTypes()[0];
            String propertyName = Introspector.decapitalize(((Method)accessibleObject).getName().substring(3));
            ValueInjector extractor = this.getParameterExtractor(clazz, factory, accessibleObject, propertyName, annotations, type, genericType);
            if (extractor == null) continue;
            long hash = 0L;
            try {
                hash = MethodHashing.methodHash((Method)accessibleObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(((Method)accessibleObject).getModifiers()) && (older = this.setterhashes.get(hash)) != null) continue;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) {
                this.setAccessible(accessibleObject);
            }
            this.setters.add(new SetterMethod((Method)accessibleObject, extractor));
            this.setterhashes.put(hash, (Method)accessibleObject);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.populateMap(clazz.getSuperclass(), factory);
        }
    }

    private ValueInjector getParameterExtractor(Class<?> clazz, ResteasyProviderFactory factory, AccessibleObject accessibleObject, String defaultName, Annotation[] annotations, Class<?> type, Type genericType) {
        boolean extractBody = FindAnnotation.findAnnotation((Annotation[])annotations, Body.class) != null;
        ValueInjector injector = factory.getInjectorFactory().createParameterExtractor(clazz, accessibleObject, defaultName, type, genericType, annotations, extractBody, factory);
        return injector;
    }

    public CompletionStage<Void> inject(HttpRequest request, HttpResponse response, Object target, boolean unwrapAsync) throws Failure {
        CompletionStage<Object> ret = null;
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            Object injectValue = entry.getValue().inject(request, response, unwrapAsync);
            if (injectValue != null && injectValue instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectValue).thenAccept(value -> {
                    try {
                        ((Field)entry.getKey()).set(target, CompletionStageHolder.resolve(value));
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException((Throwable)e);
                    }
                }));
                continue;
            }
            try {
                entry.getKey().set(target, CompletionStageHolder.resolve(injectValue));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        for (SetterMethod setter : this.setters) {
            Object injectedValue = setter.extractor.inject(request, response, unwrapAsync);
            if (injectedValue != null && injectedValue instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedValue).thenAccept(value -> {
                    try {
                        setter.method.invoke(target, CompletionStageHolder.resolve(value));
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ApplicationException(e.getCause());
                    }
                }));
                continue;
            }
            try {
                setter.method.invoke(target, CompletionStageHolder.resolve(injectedValue));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return ret;
    }

    public CompletionStage<Void> inject(Object target, boolean unwrapAsync) {
        Object injectedValue;
        CompletionStage<Object> ret = null;
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            injectedValue = entry.getValue().inject(unwrapAsync);
            if (injectedValue != null && injectedValue instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedValue).thenAccept(value -> {
                    try {
                        ((Field)entry.getKey()).set(target, CompletionStageHolder.resolve(value));
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException((Throwable)e);
                    }
                }));
                continue;
            }
            try {
                entry.getKey().set(target, CompletionStageHolder.resolve(injectedValue));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        for (SetterMethod setter : this.setters) {
            injectedValue = setter.extractor.inject(unwrapAsync);
            if (injectedValue != null && injectedValue instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedValue).thenAccept(value -> {
                    try {
                        setter.method.invoke(target, CompletionStageHolder.resolve(value));
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ApplicationException(e.getCause());
                    }
                }));
                continue;
            }
            try {
                setter.method.invoke(target, CompletionStageHolder.resolve(injectedValue));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return ret;
    }

    private Field[] getDeclaredFields(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return clazz.getDeclaredFields();
                }
            });
        }
        return clazz.getDeclaredFields();
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        return clazz.getDeclaredMethods();
    }

    private void setAccessible(final AccessibleObject member) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    member.setAccessible(true);
                    return null;
                }
            });
        } else {
            member.setAccessible(true);
        }
    }

    private static class SetterMethod {
        public Method method;
        public ValueInjector extractor;

        private SetterMethod(Method method, ValueInjector extractor) {
            this.method = method;
            this.extractor = extractor;
        }
    }
}

