/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jcajce.provider.symmetric.util;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.DEROctetString;
import org.python.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import org.python.bouncycastle.util.Arrays;

public class IvAlgorithmParameters
extends BaseAlgorithmParameters {
    private byte[] iv;

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected byte[] engineGetEncoded(String string2) throws IOException {
        if (this.isASN1FormatString(string2)) {
            return new DEROctetString(this.engineGetEncoded("RAW")).getEncoded();
        }
        if (string2.equals("RAW")) {
            return Arrays.clone(this.iv);
        }
        return null;
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == IvParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
        }
        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        if (byArray.length % 8 != 0 && byArray[0] == 4 && byArray[1] == byArray.length - 2) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(byArray);
            byArray = aSN1OctetString.getOctets();
        }
        this.iv = Arrays.clone(byArray);
    }

    protected void engineInit(byte[] byArray, String string2) throws IOException {
        if (this.isASN1FormatString(string2)) {
            try {
                ASN1OctetString aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(byArray);
                this.engineInit(aSN1OctetString.getOctets());
            }
            catch (Exception exception) {
                throw new IOException("Exception decoding: " + exception);
            }
            return;
        }
        if (string2.equals("RAW")) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException("Unknown parameters format in IV parameters object");
    }

    protected String engineToString() {
        return "IV Parameters";
    }
}

