/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.DecorateTypes;
import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.annotations.Decorators;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.DecoratorProcessor;

public class DecoratorMatcher {
    public <T> T decorate(Class<T> targetClass, T target, Class type, Annotation[] annotations, MediaType mediaType) {
        HashMap meta = new HashMap();
        if (type != null) {
            this.registerDecorators(targetClass, meta, type.getAnnotations());
        }
        if (annotations != null) {
            this.registerDecorators(targetClass, meta, annotations);
        }
        if (meta.size() == 0) {
            return target;
        }
        MediaTypeMap typeMap = new MediaTypeMap();
        for (Class<?> decoratorAnnotation : meta.keySet()) {
            Decorators decorators = decoratorAnnotation.getAnnotation(Decorators.class);
            if (decorators != null) {
                for (Decorator decorator : decorators.values()) {
                    this.injectDecorator(typeMap, decoratorAnnotation, decorator);
                }
                continue;
            }
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            this.injectDecorator(typeMap, decoratorAnnotation, decorator);
        }
        List list = typeMap.getPossible(mediaType);
        for (Class decoratorAnnotation : list) {
            Annotation annotation = meta.get(decoratorAnnotation);
            Decorators decorators = decoratorAnnotation.getAnnotation(Decorators.class);
            if (decorators != null) {
                for (Decorator decorator : decorators.values()) {
                    if (!decorator.target().isAssignableFrom(target.getClass())) continue;
                    target = this.doDecoration(target, type, annotations, mediaType, annotation, decorator);
                }
                continue;
            }
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            target = this.doDecoration(target, type, annotations, mediaType, annotation, decorator);
        }
        return target;
    }

    private <T> T doDecoration(T target, Class type, Annotation[] annotations, MediaType mediaType, Annotation annotation, Decorator decorator) {
        DecoratorProcessor processor = null;
        try {
            processor = (DecoratorProcessor)decorator.processor().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        target = processor.decorate(target, annotation, type, annotations, mediaType);
        return target;
    }

    private void injectDecorator(MediaTypeMap<Class<?>> typeMap, Class<?> decoratorAnnotation, Decorator decorator) {
        String[] mediaTypes = new String[]{"*/*"};
        DecorateTypes produces = decorator.processor().getAnnotation(DecorateTypes.class);
        if (produces != null) {
            mediaTypes = produces.value();
        }
        for (String pType : mediaTypes) {
            typeMap.add(pType, decoratorAnnotation);
        }
    }

    public <T> boolean hasDecorator(Class<T> targetClass, Annotation[] annotations) {
        if (targetClass == null || annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            Decorators decorators = annotation.annotationType().getAnnotation(Decorators.class);
            if (decorators != null) {
                for (Decorator decorator : decorators.values()) {
                    if (decorator == null || !decorator.target().isAssignableFrom(targetClass)) continue;
                    return true;
                }
                continue;
            }
            Decorator decorator = annotation.annotationType().getAnnotation(Decorator.class);
            if (decorator == null || !decorator.target().isAssignableFrom(targetClass)) continue;
            return true;
        }
        return false;
    }

    private <T> void registerDecorators(Class<T> targetClass, HashMap<Class<?>, Annotation> meta, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Decorators decorators = annotation.annotationType().getAnnotation(Decorators.class);
            if (decorators != null) {
                for (Decorator decorator : decorators.values()) {
                    this.putMeta(targetClass, meta, annotation, decorator);
                }
                continue;
            }
            Decorator decorator = annotation.annotationType().getAnnotation(Decorator.class);
            this.putMeta(targetClass, meta, annotation, decorator);
        }
    }

    private <T> void putMeta(Class<T> targetClass, HashMap<Class<?>, Annotation> meta, Annotation annotation, Decorator decorator) {
        if (decorator != null && targetClass.isAssignableFrom(decorator.target())) {
            meta.put(annotation.annotationType(), annotation);
        }
    }
}

