/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DateUtil;

public abstract class AbstractBuiltResponse
extends Response {
    protected Object entity;
    protected int status = 200;
    protected String reason = "Unknown Code";
    protected Headers<Object> metadata = new Headers();
    protected Annotation[] annotations;
    protected Class entityClass;
    protected Type genericType;
    protected HeaderValueProcessor processor;
    protected volatile boolean isClosed;
    protected InputStream is;
    protected byte[] bufferedEntity;
    protected volatile boolean streamRead;
    protected volatile boolean streamFullyRead;

    public AbstractBuiltResponse() {
    }

    public AbstractBuiltResponse(int status, String reason, Headers<Object> metadata, Object entity, Annotation[] entityAnnotations) {
        this.setEntity(entity);
        this.status = status;
        this.metadata = metadata;
        this.annotations = entityAnnotations;
        if (reason != null) {
            this.reason = reason;
        }
    }

    protected abstract InputStream getInputStream();

    protected abstract void setInputStream(InputStream var1);

    protected abstract InputStream getEntityStream();

    public abstract void releaseConnection() throws IOException;

    public abstract void releaseConnection(boolean var1) throws IOException;

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    protected HeaderValueProcessor getHeaderValueProcessor() {
        if (this.processor != null) {
            return this.processor;
        }
        return ResteasyProviderFactory.getInstance();
    }

    public Object getEntity() {
        this.abortIfClosed();
        return this.entity;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public Response.StatusType getStatusInfo() {
        Object statusType = Response.Status.fromStatusCode((int)this.status);
        if (statusType == null) {
            statusType = new Response.StatusType(){

                public int getStatusCode() {
                    return AbstractBuiltResponse.this.status;
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf((int)AbstractBuiltResponse.this.status);
                }

                public String getReasonPhrase() {
                    return AbstractBuiltResponse.this.reason;
                }
            };
        }
        return statusType;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setEntity(Object entity) {
        if (entity == null) {
            this.entity = null;
            this.genericType = null;
            this.entityClass = null;
        } else if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            this.entity = ge.getEntity();
            this.genericType = ge.getType();
            this.entityClass = ge.getRawType();
        } else {
            this.entity = entity;
            this.entityClass = entity.getClass();
            this.genericType = null;
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setReasonPhrase(String reason) {
        this.reason = reason;
    }

    public void setMetadata(MultivaluedMap<String, Object> metadata) {
        this.metadata = new Headers();
        this.metadata.putAll(metadata);
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void addMethodAnnotations(Annotation[] methodAnnotations) {
        ArrayList<Annotation> ann = new ArrayList<Annotation>();
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                ann.add(annotation);
            }
        }
        for (Annotation annotation : methodAnnotations) {
            ann.add(annotation);
        }
        this.annotations = ann.toArray(new Annotation[ann.size()]);
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public <T> T readEntity(Class<T> type, Annotation[] annotations) {
        return this.readEntity(type, null, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType.getRawType(), entityType.getType(), annotations);
    }

    public <T> T readEntity(Class<T> type) {
        return this.readEntity(type, null, null);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return this.readEntity(entityType.getRawType(), entityType.getType(), null);
    }

    public abstract <T> T readEntity(Class<T> var1, Type var2, Annotation[] var3);

    protected void resetEntity() {
        this.entity = null;
        this.bufferedEntity = null;
        this.streamFullyRead = false;
        this.streamRead = false;
    }

    public void setStreamRead(Boolean b) {
        this.streamRead = b;
    }

    public void setStreamFullyRead(Boolean b) {
        this.streamFullyRead = b;
    }

    public boolean hasEntity() {
        this.abortIfClosed();
        return this.entity != null;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void abortIfClosed() {
        if (this.bufferedEntity == null && this.isClosed()) {
            throw new IllegalStateException(Messages.MESSAGES.responseIsClosed());
        }
    }

    public void close() {
        this.isClosed = true;
    }

    public Locale getLanguage() {
        Object obj = this.metadata.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        return new LocaleDelegate().fromString(this.toHeaderString(obj));
    }

    public int getLength() {
        Object obj = this.metadata.getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.valueOf(this.toHeaderString(obj));
    }

    public MediaType getMediaType() {
        Object obj = this.metadata.getFirst("Content-Type");
        if (obj instanceof MediaType) {
            return (MediaType)obj;
        }
        if (obj == null) {
            return null;
        }
        return MediaType.valueOf((String)this.toHeaderString(obj));
    }

    public Map<String, NewCookie> getCookies() {
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        Object list = this.metadata.get("Set-Cookie");
        if (list == null) {
            return cookies;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof NewCookie) {
                NewCookie cookie = (NewCookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = this.toHeaderString(obj);
            NewCookie cookie = NewCookie.valueOf((String)str);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    public EntityTag getEntityTag() {
        Object d = this.metadata.getFirst("ETag");
        if (d == null) {
            return null;
        }
        if (d instanceof EntityTag) {
            return (EntityTag)d;
        }
        return EntityTag.valueOf((String)this.toHeaderString(d));
    }

    public Date getDate() {
        Object d = this.metadata.getFirst("Date");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    public Date getLastModified() {
        Object d = this.metadata.getFirst("Last-Modified");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    public Set<String> getAllowedMethods() {
        HashSet<String> allowedMethods = new HashSet<String>();
        Object allowed = this.metadata.get("Allow");
        if (allowed == null) {
            return allowedMethods;
        }
        Iterator iterator = allowed.iterator();
        while (iterator.hasNext()) {
            Object header = iterator.next();
            if (header != null && header instanceof String) {
                String[] list;
                for (String str : list = ((String)header).split(",")) {
                    if ("".equals(str.trim())) continue;
                    allowedMethods.add(str.trim().toUpperCase());
                }
                continue;
            }
            allowedMethods.add(this.toHeaderString(header).toUpperCase());
        }
        return allowedMethods;
    }

    protected String toHeaderString(Object header) {
        if (header instanceof String) {
            return (String)header;
        }
        return this.getHeaderValueProcessor().toHeaderString(header);
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        CaseInsensitiveMap<String> map = new CaseInsensitiveMap<String>();
        for (Map.Entry entry : this.metadata.entrySet()) {
            for (Object obj : entry.getValue()) {
                map.add((String)entry.getKey(), this.toHeaderString(obj));
            }
        }
        return map;
    }

    public String getHeaderString(String name) {
        Object vals = this.metadata.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Iterator iterator = vals.iterator();
        while (iterator.hasNext()) {
            Object val = iterator.next();
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            if (val == null) {
                val = "";
            }
            if ((val = this.toHeaderString(val)) == null) {
                val = "";
            }
            builder.append(val);
        }
        return builder.toString();
    }

    public URI getLocation() {
        Object uri = this.metadata.getFirst("Location");
        if (uri == null) {
            return null;
        }
        if (uri instanceof URI) {
            return (URI)uri;
        }
        String str = null;
        str = uri instanceof String ? (String)uri : this.toHeaderString(uri);
        return URI.create(str);
    }

    public Set<Link> getLinks() {
        LinkHeaders linkHeaders = this.getLinkHeaders();
        HashSet<Link> links = new HashSet<Link>();
        links.addAll(linkHeaders.getLinks());
        return links;
    }

    private LinkHeaders getLinkHeaders() {
        LinkHeaders linkHeaders = new LinkHeaders();
        linkHeaders.addLinkObjects(this.metadata, this.getHeaderValueProcessor());
        return linkHeaders;
    }

    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    protected static class InputStreamWrapper<T extends BuiltResponse>
    extends FilterInputStream {
        private T response;

        public InputStreamWrapper(InputStream in, T response) {
            super(in);
            this.response = response;
        }

        @Override
        public int read() throws IOException {
            return this.checkEOF(super.read());
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.checkEOF(super.read(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.checkEOF(super.read(b, off, len));
        }

        private int checkEOF(int v) {
            ((AbstractBuiltResponse)((Object)this.response)).setStreamRead(true);
            if (v < 0) {
                ((AbstractBuiltResponse)((Object)this.response)).setStreamFullyRead(true);
            }
            return v;
        }

        @Override
        public void close() throws IOException {
            super.close();
            ((AbstractBuiltResponse)((Object)this.response)).close();
        }
    }

    private final class LinkHeaders {
        private Map<String, Link> linksByRelationship = new HashMap<String, Link>();
        private List<Link> links = new ArrayList<Link>();

        private LinkHeaders() {
        }

        public LinkHeaders addLinkObjects(MultivaluedMap<String, Object> headers, HeaderValueProcessor factory) {
            List values = (List)headers.get((Object)"Link");
            if (values == null) {
                return this;
            }
            for (Object val : values) {
                if (val instanceof Link) {
                    this.addLink((Link)val);
                    continue;
                }
                if (val instanceof String) {
                    for (String link : ((String)val).split(",")) {
                        this.addLink(Link.valueOf((String)link));
                    }
                    continue;
                }
                String str = factory.toHeaderString(val);
                this.addLink(Link.valueOf((String)str));
            }
            return this;
        }

        public LinkHeaders addLink(Link link) {
            this.links.add(link);
            for (String rel : link.getRels()) {
                this.linksByRelationship.put(rel, link);
            }
            return this;
        }

        public Link getLinkByRelationship(String rel) {
            return this.linksByRelationship.get(rel);
        }

        public List<Link> getLinks() {
            return this.links;
        }
    }
}

